/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgykubejs;

import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;

public abstract class AlchemicalDerivativeItemType
extends ItemBuilder {
    public transient ResourceLocation sourceItem = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone");
    public transient ResourceLocation sourceTag;
    public transient ResourceLocation jarIcon = ResourceLocation.fromNamespaceAndPath((String)"theurgy", (String)"empty_jar_icon");
    public transient String sourceName = "";
    public transient AlchemicalDerivativeTier derivativeTier = AlchemicalDerivativeTier.ABUNDANT;
    public transient boolean generateTooltipLangEntry = true;
    public transient boolean generateNameLangEntry = true;
    public transient boolean provideDerivativeInformationAsTooltipParam = true;
    public transient boolean provideDerivativeInformationAsNameParam = true;

    public AlchemicalDerivativeItemType(ResourceLocation rl) {
        super(rl);
        this.parentModel(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"builtin/entity"));
    }

    protected Item.Properties decorateWithSource(Item.Properties properties) {
        if (this.sourceItem != null) {
            properties.component((Supplier)DataComponentRegistry.SOURCE_ITEM, (Object)((Holder)BuiltInRegistries.ITEM.getHolder(this.sourceItem).get()));
        } else if (this.sourceTag != null) {
            properties.component((Supplier)DataComponentRegistry.SOURCE_TAG, (Object)ItemTags.create((ResourceLocation)this.sourceTag));
        }
        return properties;
    }

    @Info(value="If true, KubeJS will generate a lang file entry for the tooltip of this derivative with default texts.")
    public ItemBuilder generateTooltipLangEntry(boolean value) {
        this.generateTooltipLangEntry = value;
        return this;
    }

    @Info(value="If true, KubeJS will generate a lang file entry for the name of this derivative with default texts.")
    public ItemBuilder generateNameLangEntry(boolean value) {
        this.generateNameLangEntry = value;
        return this;
    }

    @Info(value="If true, the tooltip can access alchemical derivative information as \"%s\" params. Should generally always be true.")
    public ItemBuilder provideDerivativeInformationAsTooltipParam(boolean value) {
        this.provideDerivativeInformationAsTooltipParam = value;
        return this;
    }

    @Info(value="If true, the item name can access alchemical derivative information as \"%s\" params. Should generally always be true.")
    public ItemBuilder provideDerivativeInformationAsNameParam(boolean value) {
        this.provideDerivativeInformationAsNameParam = value;
        return this;
    }

    @Info(value="Sets the item that will be used as jar icon. This will be rendered as background behind the source item.")
    public ItemBuilder jarIcon(ResourceLocation id) {
        this.jarIcon = id;
        return this;
    }

    @Info(value="Sets the item the derivative is made from. This will be used for texts, tooltips and icons. Note: Consider using sourceTag() instead.")
    public ItemBuilder sourceItem(ResourceLocation id) {
        this.sourceItem = id;
        return this;
    }

    @Info(value="Sets the tag the derivative is made from. This will be used for texts, tooltips and icons.")
    public ItemBuilder sourceTag(ResourceLocation id) {
        this.sourceTag = id;
        return this;
    }

    @Info(value="Sets the name that will be displayed as the source name for this derivative")
    public ItemBuilder sourceName(String name) {
        this.sourceName = name;
        return this;
    }

    @Info(value="Sets the derivative Tier (ABUNDANT, COMMON, RARE, PRECIOUS).")
    public ItemBuilder derivativeTier(AlchemicalDerivativeTier tier) {
        this.derivativeTier = tier;
        return this;
    }

    public void generateLang(LangKubeEvent lang) {
        super.generateLang(lang);
    }
}

