/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class BeeEffect
implements INBTSerializable<CompoundTag> {
    private Map<Holder<MobEffect>, Integer> effects = new HashMap<Holder<MobEffect>, Integer>();

    public BeeEffect(Map<Holder<MobEffect>, Integer> effects) {
        this.effects = effects;
    }

    public BeeEffect(HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeNBT(provider, tag);
    }

    public Map<Holder<MobEffect>, Integer> getEffects() {
        return this.effects;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("i", this.effects.size());
        this.getEffects().forEach((effect, duration) -> {
            CompoundTag effectTag = new CompoundTag();
            effectTag.putString("effect", String.valueOf(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)effect.value()))));
            effectTag.putInt("duration", duration.intValue());
            tag.put("effect_" + (tag.size() - 1), (Tag)effectTag);
        });
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.effects = new HashMap<Holder<MobEffect>, Integer>();
        IntStream.range(0, tag.getInt("i")).forEach(i -> {
            CompoundTag effectTag = tag.getCompound("effect_" + i);
            String effectName = effectTag.getString("effect");
            MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)effectName));
            this.effects.put((Holder<MobEffect>)Holder.direct((Object)effect), effectTag.getInt("duration"));
        });
    }
}

