/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.HeatedCentrifuge;
import cy.jdkdigital.productivebees.common.block.entity.HeatedCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HeatedCentrifugeContainer
extends CentrifugeContainer {
    public final HeatedCentrifugeBlockEntity blockEntity1;

    public HeatedCentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, HeatedCentrifugeContainer.getBlockEntity(playerInventory, data));
    }

    public HeatedCentrifugeContainer(int windowId, Inventory playerInventory, final HeatedCentrifugeBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.HEATED_CENTRIFUGE.get(), windowId, playerInventory, blockEntity);
        this.blockEntity1 = blockEntity;
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (blockEntity.energyHandler.getEnergyStored() > 0) {
                    blockEntity.energyHandler.extractEnergy(blockEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    blockEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
    }

    private static HeatedCentrifugeBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof HeatedCentrifugeBlockEntity) {
            HeatedCentrifugeBlockEntity tile = (HeatedCentrifugeBlockEntity)tileAtPos;
            return tile;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof HeatedCentrifuge && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getBlockEntity() {
        return this.blockEntity1;
    }
}

