/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.emi;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeEmiStack;
import cy.jdkdigital.productivebees.compat.emi.ProductiveBeesEmiPlugin;
import cy.jdkdigital.productivebees.init.ModTags;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class BeeBreedingEmiRecipe
extends BasicEmiRecipe {
    ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_breeding_recipe.png");

    public BeeBreedingEmiRecipe(RecipeHolder<BeeBreedingRecipe> recipe) {
        super(ProductiveBeesEmiPlugin.BEE_BREEDING_CATEGORY, recipe.id(), 126, 70);
        this.inputs.add(BeeEmiStack.of(((BeeBreedingRecipe)recipe.value()).parent1.get()));
        this.inputs.add(BeeEmiStack.of(((BeeBreedingRecipe)recipe.value()).parent2.get()));
        Entity bee1 = ((BeeBreedingRecipe)recipe.value()).parent1.get().getCachedEntity((Level)Minecraft.getInstance().level);
        if (bee1 instanceof ProductiveBee) {
            ProductiveBee pBee = (ProductiveBee)bee1;
            this.inputs.add(EmiIngredient.of(pBee.getBreedingItems().stream().map(EmiStack::of).toList()));
        } else {
            this.inputs.add(EmiIngredient.of(ModTags.DEFAULT_BREEDING));
        }
        Entity bee2 = ((BeeBreedingRecipe)recipe.value()).parent2.get().getCachedEntity((Level)Minecraft.getInstance().level);
        if (bee2 instanceof ProductiveBee) {
            ProductiveBee pBee = (ProductiveBee)bee2;
            this.inputs.add(EmiIngredient.of(pBee.getBreedingItems().stream().map(EmiStack::of).toList()));
        } else {
            this.inputs.add(EmiIngredient.of(ModTags.DEFAULT_BREEDING));
        }
        this.outputs.add(BeeEmiStack.of(((BeeBreedingRecipe)recipe.value()).offspring.get()));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(this.location, 0, 0, 126, 70, 0, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 11, 16).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 45, 16).drawBack(false);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 104, 17).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 9, 37).drawBack(false);
        widgets.addSlot((EmiIngredient)this.inputs.get(3), 43, 37).drawBack(false);
    }
}

