/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.BeeBombEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BeeBomb
extends Item {
    private static final String BEES_KEY = "productivebees_beebomb_bees";
    private final boolean isAngry;

    public BeeBomb(Item.Properties properties, boolean isAngry) {
        super(properties);
        this.isAngry = isAngry;
    }

    public boolean isAngry() {
        return this.isAngry;
    }

    public static boolean isLoaded(ItemStack itemStack) {
        return BeeBomb.getBees(itemStack).size() > 0;
    }

    public static void addBee(ItemStack stack, ItemStack cage) {
        ListTag bees = BeeBomb.getBees(stack);
    }

    public static ListTag getBees(ItemStack stack) {
        ListTag bees = new ListTag();
        return bees;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            BeeBombEntity bombEntity = new BeeBombEntity(level, (LivingEntity)player);
            bombEntity.setItem(item);
            bombEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)bombEntity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.getInventory().removeItem(item);
        return InteractionResultHolder.sidedSuccess((Object)item, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        ListTag beeList = BeeBomb.getBees(pStack);
        if (!beeList.isEmpty()) {
            if (Screen.hasShiftDown()) {
                pTooltipComponents.add((Component)Component.translatable((String)"productivebees.hive.tooltip.bees").withStyle(ChatFormatting.DARK_AQUA));
                for (Tag bee : beeList) {
                    String beeType = ((CompoundTag)bee).getString("entity");
                    if (beeType.startsWith("productivebees:")) {
                        pTooltipComponents.add((Component)Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(ResourceLocation.parse((String)beeType)) + "_bee")));
                        continue;
                    }
                    pTooltipComponents.add((Component)Component.literal((String)beeType));
                }
            } else {
                pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.hold_shift").withStyle(ChatFormatting.WHITE));
            }
        }
    }
}

