/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RancherBee
extends ProductiveBee {
    public PathfinderMob target = null;
    public static Predicate<Entity> predicate = entity -> entity.getType().is(ModTags.RANCHABLES);

    public RancherBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_RAIN);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.target != null) {
            if (!this.hasNectar()) {
                this.target.getNavigation().setSpeedModifier(0.0);
            } else {
                this.target.setTarget((LivingEntity)this);
                this.target = null;
            }
        }
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    public boolean isFlowerValid(BlockPos pos) {
        if (!this.level().isLoaded(pos)) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        if (blockEntity instanceof AmberBlockEntity) {
            AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
            Entity entity = amberBlockEntity.getCachedEntity();
            return entity != null && entity.getType().is(ModTags.RANCHABLES);
        }
        List entities = this.level().getEntities((Entity)this, new AABB(pos).inflate(1.0, 1.0, 1.0), predicate);
        if (!entities.isEmpty()) {
            this.target = (PathfinderMob)entities.get(0);
            this.target.addEffect(new MobEffectInstance(MobEffects.LUCK, 400));
            return true;
        }
        return RancherBee.isValidFeeder(this, this.level().getBlockEntity(pos), this::isFlowerBlock, this::isFlowerItem);
    }

    @Override
    public void postPollinate() {
        Shearable sheep;
        super.postPollinate();
        PathfinderMob pathfinderMob = this.target;
        if (pathfinderMob instanceof Shearable && (sheep = (Shearable)pathfinderMob).readyForShearing()) {
            sheep.shear(SoundSource.BLOCKS);
        }
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        return false;
    }

    @Override
    public String getFlowerType() {
        return "entity_type";
    }
}

