/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.crafting.ingredient;

import com.mojang.serialization.DataResult;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;

public class BeeIngredientFactory {
    private static Map<String, BeeIngredient> ingredientList = new HashMap<String, BeeIngredient>();
    private static int configurableBeeIngredientCount = 0;

    public static String getIngredientKey(Bee bee) {
        String type = bee.getEncodeId();
        if (bee instanceof ProductiveBee) {
            type = ((ProductiveBee)bee).getBeeType().toString();
        }
        return type;
    }

    public static Map<String, BeeIngredient> getOrCreateList(boolean removeDeprecated) {
        HashMap<String, BeeIngredient> list = new HashMap();
        if (removeDeprecated) {
            for (Map.Entry<String, BeeIngredient> entry : BeeIngredientFactory.getOrCreateList().entrySet()) {
                String beeId = entry.getKey().replace("productivebees:", "");
                if (beeId.equals("configurable_bee") || beeId.equals("villager")) continue;
                list.put(entry.getKey(), entry.getValue());
            }
        } else {
            list = BeeIngredientFactory.getOrCreateList();
        }
        return list;
    }

    public static DataResult<Supplier<BeeIngredient>> read(String name) {
        return DataResult.success(BeeIngredientFactory.getIngredient(name));
    }

    public static Supplier<BeeIngredient> getIngredient(ResourceLocation name) {
        return BeeIngredientFactory.getIngredient(name.toString());
    }

    @Nullable
    public static Supplier<BeeIngredient> getIngredient(String name) {
        return () -> BeeIngredientFactory.getOrCreateList().get(name);
    }

    public static Map<String, BeeIngredient> getOrCreateList() {
        if (ingredientList.isEmpty()) {
            try {
                for (EntityType registryObject : BuiltInRegistries.ENTITY_TYPE) {
                    if (!registryObject.is(EntityTypeTags.BEEHIVE_INHABITORS) || registryObject.equals(ModEntities.CONFIGURABLE_BEE.get())) continue;
                    EntityType bee = registryObject;
                    BeeIngredientFactory.addBee(BuiltInRegistries.ENTITY_TYPE.getKey((Object)bee).toString(), new BeeIngredient((EntityType<? extends Entity>)bee));
                }
            }
            catch (IllegalStateException e) {
                ProductiveBees.LOGGER.warn("Failed to create bee ingredient list for beehive inhabitors");
            }
        }
        if (configurableBeeIngredientCount != BeeReloadListener.INSTANCE.getData().size()) {
            configurableBeeIngredientCount = 0;
            for (Map.Entry<ResourceLocation, CompoundTag> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                ResourceLocation beeType = entry.getKey();
                EntityType bee = (EntityType)ModEntities.CONFIGURABLE_BEE.get();
                BeeIngredientFactory.addBee(beeType.toString(), new BeeIngredient((EntityType<? extends Entity>)bee, beeType, true));
                ++configurableBeeIngredientCount;
            }
        }
        return ingredientList;
    }

    public static void addBee(String name, BeeIngredient bee) {
        ingredientList.put(name, bee);
    }
}

