/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.Set;
import org.simmetrics.SetDistance;
import org.simmetrics.SetMetric;
import org.simmetrics.metrics.Math;

public final class Dice<T>
implements SetMetric<T>,
SetDistance<T> {
    @Override
    public float compare(Set<T> a, Set<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return 2.0f * (float)Math.intersection(a, b).size() / (float)(a.size() + b.size());
    }

    @Override
    public float distance(Set<T> a, Set<T> b) {
        return 1.0f - this.compare(a, b);
    }

    public String toString() {
        return "Dice";
    }
}

