/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.facade.FacadeData;
import ca.teamdman.sfm.common.facade.FacadePlanAnalysisResult;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.ConfirmationParams;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public record ChangeWorldBlockFacadePlan(IFacadableBlock worldBlock, Set<BlockPos> positions) implements IFacadePlan
{
    @Override
    public void apply(Level level) {
        this.positions().forEach(pos -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IFacadeBlockEntity) {
                IFacadeBlockEntity oldFacadeBlockEntity = (IFacadeBlockEntity)patt0$temp;
                BlockState oldState = level.getBlockState(pos);
                FacadeData oldFacadeData = oldFacadeBlockEntity.getFacadeData();
                if (oldFacadeData != null && oldState.hasProperty(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY)) {
                    level.setBlock(pos, (BlockState)((BlockState)this.worldBlock().getFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos).setValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY, (Comparable)((Object)((FacadeTransparency)((Object)((Object)oldState.getValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY))))))).setValue((Property)LightBlock.LEVEL, (Comparable)((Integer)oldState.getValue((Property)LightBlock.LEVEL))), 10);
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof IFacadeBlockEntity) {
                        IFacadeBlockEntity facadeBlockEntity = (IFacadeBlockEntity)blockEntity;
                        facadeBlockEntity.updateFacadeData(oldFacadeData);
                    } else {
                        SFM.LOGGER.warn("Block entity {} at {} is not a facade block entity", pos, (Object)blockEntity);
                    }
                }
            } else {
                level.setBlock(pos, this.worldBlock().getNonFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos), 10);
            }
        });
    }

    @Override
    @Nullable
    public ConfirmationParams computeWarning(Level level) {
        FacadePlanAnalysisResult analysisResult = FacadePlanAnalysisResult.analyze(level, this.positions);
        if (analysisResult.shouldWarn()) {
            return ConfirmationParams.of(LocalizationKeys.FACADE_CONFIRM_CHANGE_WORLD_BLOCK_SCREEN_TITLE.getComponent(), LocalizationKeys.FACADE_CONFIRM_CHANGE_WORLD_BLOCK_SCREEN_MESSAGE.getComponent(analysisResult.countAffected()));
        }
        return null;
    }
}

