/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_editor;

import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface ISFMTextEditScreenOpenContext {
    public String initialValue();

    default public void onTryClose(String latestContent, Runnable finalizeClose) {
        if (this.initialValue().equals(latestContent)) {
            finalizeClose.run();
        } else {
            ConfirmScreen exitWithoutSavingConfirmScreen = new ConfirmScreen(doSave -> {
                SFMScreenChangeHelpers.popScreen();
                if (doSave) {
                    finalizeClose.run();
                }
            }, (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_NO_BUTTON.getComponent());
            SFMScreenChangeHelpers.setOrPushScreen((Screen)exitWithoutSavingConfirmScreen);
            exitWithoutSavingConfirmScreen.setDelay(20);
        }
    }

    default public void onSaveAndClose(String latestContent) {
        this.saveWriter().accept(latestContent);
        SFMScreenChangeHelpers.popScreen();
    }

    public Consumer<String> saveWriter();

    public LabelPositionHolder labelPositionHolder();
}

