/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.screen.LogsScreenMultiLineEditBox;
import ca.teamdman.sfm.client.screen.LogsTextStylingHelper;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.net.ServerboundManagerClearLogsPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerSetLogLevelPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.timing.SFMEpochInstant;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;

public class LogsScreen
extends Screen {
    private final ManagerContainerMenu MENU;
    private LogsScreenMultiLineEditBox textarea;
    private int lastSize = 0;
    private Map<Level, Button> levelButtons = new HashMap<Level, Button>();
    private String lastKnownLogLevel;

    public LogsScreen(ManagerContainerMenu menu) {
        super((Component)LocalizationKeys.LOGS_SCREEN_TITLE.getComponent());
        this.MENU = menu;
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.isSpectator();
    }

    public void onLogLevelChange() {
        for (Map.Entry<Level, Button> entry : this.levelButtons.entrySet()) {
            Level level = entry.getKey();
            Button button = entry.getValue();
            button.active = !this.MENU.logLevel.equals(level.name());
        }
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public void onClose() {
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(this.MENU.containerId, this.MENU.MANAGER_POSITION, false));
        super.onClose();
    }

    public void scrollToBottom() {
        this.textarea.scrollToBottom();
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.textarea.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.textarea.setValue(prev);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = pGuiGraphics.pose();
        this.renderTransparentBackground(pGuiGraphics);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        SFMWidgetUtils.hideTooltipsWhenNotFocused(this, this.renderables);
        SFMWidgetUtils.renderChildTooltips(poseStack, pMouseX, pMouseY, this.renderables);
        if (!this.MENU.logLevel.equals(this.lastKnownLogLevel)) {
            this.onLogLevelChange();
        }
    }

    public boolean shouldRebuildText() {
        return this.MENU.logs.size() != this.lastSize;
    }

    public void rebuildText() {
        if (this.MENU.logs.isEmpty() && this.MENU.logLevel.equals(Level.OFF.name())) {
            this.MENU.logs.add(new TranslatableLogEvent(Level.INFO, SFMEpochInstant.now(), LocalizationKeys.LOGS_GUI_NO_CONTENT.get()));
        }
        this.textarea.styledTextContentLines = LogsTextStylingHelper.getStyledLogs(this.MENU.logs);
        StringBuilder sb = new StringBuilder();
        for (MutableComponent line : this.textarea.styledTextContentLines) {
            sb.append(line.getString()).append("\n");
        }
        this.textarea.setValue(sb.toString());
        this.textarea.textRenderWidget.setStyledTextContentLines(this.textarea.styledTextContentLines);
        this.textarea.textRenderWidget.setTextContent(this.textarea.getValue());
        this.lastSize = this.MENU.logs.size();
    }

    protected void init() {
        Level[] levelArray;
        super.init();
        assert (this.minecraft != null);
        this.textarea = (LogsScreenMultiLineEditBox)this.addRenderableWidget((GuiEventListener)new LogsScreenMultiLineEditBox(this, this.font, this.width / 2 - 200, this.height / 2 - 90, 400, 180, (Component)Component.literal((String)""), (Component)Component.literal((String)"")));
        this.rebuildText();
        this.setInitialFocus((GuiEventListener)this.textarea);
        if (this.isReadOnly()) {
            levelArray = new Level[]{};
        } else {
            Level[] levelArray2 = new Level[6];
            levelArray2[0] = Level.OFF;
            levelArray2[1] = Level.TRACE;
            levelArray2[2] = Level.DEBUG;
            levelArray2[3] = Level.INFO;
            levelArray2[4] = Level.WARN;
            levelArray = levelArray2;
            levelArray2[5] = Level.ERROR;
        }
        Level[] buttons = levelArray;
        int buttonWidth = 60;
        int buttonHeight = 20;
        int spacing = 5;
        int startX = (this.width - (buttonWidth * buttons.length + spacing * 4)) / 2;
        int startY = this.height / 2 - 115;
        int buttonIndex = 0;
        this.levelButtons = new HashMap<Level, Button>();
        for (Level level : buttons) {
            Button levelButton = new SFMButtonBuilder().setSize(buttonWidth, buttonHeight).setPosition(startX + (buttonWidth + spacing) * buttonIndex, startY).setText((Component)Component.literal((String)level.name())).setOnPress(button -> {
                String logLevel = level.name();
                SFMPackets.sendToServer(new ServerboundManagerSetLogLevelPacket(this.MENU.containerId, this.MENU.MANAGER_POSITION, logLevel));
                this.MENU.logLevel = logLevel;
                this.onLogLevelChange();
            }).build();
            this.levelButtons.put(level, levelButton);
            this.addRenderableWidget((GuiEventListener)levelButton);
            ++buttonIndex;
        }
        this.onLogLevelChange();
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 200, this.height / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON).setOnPress(this::onCopyLogsClicked).setTooltip((Screen)this, this.font, LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 - 100, this.height / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.GUI_DONE).setOnPress(p_97691_ -> this.onClose()).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        if (!this.isReadOnly()) {
            this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 + 115, this.height / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_CLEAR_LOGS_BUTTON).setOnPress(button -> {
                SFMPackets.sendToServer(new ServerboundManagerClearLogsPacket(this.MENU.containerId, this.MENU.MANAGER_POSITION));
                this.MENU.logs.clear();
            }).build());
        }
    }

    private void onCopyLogsClicked(Button button) {
        StringBuilder clipboardBuilder = new StringBuilder();
        clipboardBuilder.append(SFMDiagnostics.getDiagnosticsSummary(this.MENU.getDisk()));
        clipboardBuilder.append("\n-- LOGS --\n");
        if (LogsScreen.hasShiftDown()) {
            for (TranslatableLogEvent log : this.MENU.logs) {
                clipboardBuilder.append(log.level().name()).append(" ");
                clipboardBuilder.append(log.instant().toString()).append(" ");
                clipboardBuilder.append(log.contents().getKey());
                for (Object arg : log.contents().getArgs()) {
                    clipboardBuilder.append(" ").append(arg);
                }
                clipboardBuilder.append("\n");
            }
        } else {
            for (MutableComponent line : this.textarea.styledTextContentLines) {
                clipboardBuilder.append(line.getString()).append("\n");
            }
        }
        Minecraft.getInstance().keyboardHandler.setClipboard(clipboardBuilder.toString());
    }
}

