/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.jei;

import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PrintingPressJEICategory
implements IRecipeCategory<PrintingPressRecipe> {
    public static final RecipeType<PrintingPressRecipe> RECIPE_TYPE = RecipeType.create((String)"sfm", (String)"printing_press", PrintingPressRecipe.class);
    private final IDrawable icon;
    private final IDrawable slot;

    public PrintingPressJEICategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)SFMBlocks.PRINTING_PRESS_BLOCK.get()));
        this.slot = jeiHelpers.getGuiHelper().getSlotDrawable();
    }

    public RecipeType<PrintingPressRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return LocalizationKeys.PRINTING_PRESS_JEI_CATEGORY_TITLE.getComponent();
    }

    public int getWidth() {
        return 50;
    }

    public int getHeight() {
        return 54;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PrintingPressRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addItemStacks(Arrays.stream(recipe.form().getItems()).map(FormItem::createFormFromReference).toList())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(recipe.ink())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addIngredients(recipe.paper())).setBackground(this.slot, -1, -1);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 25, 18).addIngredients(recipe.form());
    }
}

