/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.data;

import com.google.gson.JsonElement;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockstateProvider
extends BlockStateProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockstateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "generatorgalore", exFileHelper);
        this.packOutput = packOutput;
    }

    protected void registerStatesAndModels() {
        GeneratorRegistry.generators.forEach((resourceLocation, generatorObject) -> {
            Block block = generatorObject.getBlockSupplier().get();
            this.makeGeneratorBlock(block, "block/generator_base");
            ResourceLocation baseGen = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.makeGeneratorBlock((Block)BuiltInRegistries.BLOCK.get(baseGen.withPath(p -> p + "_8x")), "block/generator_base_8x");
            this.makeGeneratorBlock((Block)BuiltInRegistries.BLOCK.get(baseGen.withPath(p -> p + "_64x")), "block/generator_base_64x");
        });
    }

    private void makeGeneratorBlock(Block block, String baseModel) {
        BlockModelBuilder generatorParentModel = this.generatorTextureMap(block, (BlockModelBuilder)this.models().withExistingParent(this.blockTexture(block).toString(), ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)baseModel)));
        BlockModelBuilder generatorOnParentModel = this.generatorOnTextureMap(block, (BlockModelBuilder)this.models().withExistingParent(String.valueOf(this.blockTexture(block)) + "_on", generatorParentModel.getLocation()));
        this.horizontalBlock(block, blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? generatorOnParentModel : generatorParentModel);
        this.simpleBlockItem(block, (ModelFile)generatorParentModel);
    }

    private BlockModelBuilder generatorTextureMap(Block pBlock, BlockModelBuilder modelBuilder) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.texture("side", this.extend(pBlock, "_side"))).texture("top", this.extend(pBlock, "_top_off"))).texture("bottom", this.extend(pBlock, "_bottom"))).texture("face", this.extend(pBlock, "_front"));
    }

    private BlockModelBuilder generatorOnTextureMap(Block pBlock, BlockModelBuilder modelBuilder) {
        return (BlockModelBuilder)((BlockModelBuilder)modelBuilder.texture("front", ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"block/generator_on_glow"))).texture("top", this.extend(pBlock, "_top_on"));
    }

    private ResourceLocation extend(Block pBlock, String suffix) {
        return this.blockTexture(pBlock).withPath(p -> p.replace("_8x", "").replace("_64x", "") + suffix);
    }

    private ResourceLocation blockKey(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private ResourceLocation itemKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }
}

