/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.init.ModRecipeTypes;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public record FluidFuelRecipe(List<FluidStack> fuels, ItemStack generator, float rate, float consumptionRate) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(RecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return null;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.FLUID_FUEL.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.FLUID_FUEL_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidFuelRecipe> {
        private static final MapCodec<FluidFuelRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)FluidStack.CODEC.listOf().fieldOf("fuels").orElse(List.of()).forGetter(recipe -> recipe.fuels), (App)ItemStack.CODEC.fieldOf("generator").forGetter(recipe -> recipe.generator), (App)Codec.FLOAT.fieldOf("rate").forGetter(recipe -> Float.valueOf(recipe.rate)), (App)Codec.FLOAT.fieldOf("consumptionRate").forGetter(recipe -> Float.valueOf(recipe.consumptionRate))).apply((Applicative)builder, FluidFuelRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidFuelRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FluidFuelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidFuelRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static FluidFuelRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new FluidFuelRecipe((List)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readFloat(), buffer.readFloat());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error reading item fuels recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, FluidFuelRecipe recipe) {
            try {
                FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.fuels());
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.generator());
                buffer.writeFloat(recipe.rate());
                buffer.writeFloat(recipe.consumptionRate());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error writing item fuels recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

