/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.network;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SoulElytraBoostPacket(boolean bool) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SoulElytraBoostPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SoulElytraBoostPacket::bool, SoulElytraBoostPacket::new);
    public static final ResourceLocation ID = DeeperDarker.rl("soul_elytra_boost");
    public static final CustomPacketPayload.Type<SoulElytraBoostPacket> TYPE = new CustomPacketPayload.Type(ID);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            if (DeeperDarkerConfig.soulElytraCooldown == -1) {
                player.displayClientMessage((Component)Component.translatable((String)"item.deeperdarker.soul_elytra.no_cooldown"), true);
                return;
            }
            if (player.isFallFlying() && ((ItemStack)player.getInventory().armor.get(2)).is((Item)DDItems.SOUL_ELYTRA.get()) && !player.getCooldowns().isOnCooldown((Item)DDItems.SOUL_ELYTRA.get())) {
                FireworkRocketEntity rocket = new FireworkRocketEntity(level, new ItemStack((ItemLike)Items.FIREWORK_ROCKET), (LivingEntity)player);
                level.addFreshEntity((Entity)rocket);
                player.getCooldowns().addCooldown((Item)DDItems.SOUL_ELYTRA.get(), DeeperDarkerConfig.soulElytraCooldown);
            }
        });
    }
}

