/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.datagen;

import dev.su5ed.mffs.datagen.AdvancementsGen;
import dev.su5ed.mffs.datagen.BlockStateGen;
import dev.su5ed.mffs.datagen.BlockTagsGen;
import dev.su5ed.mffs.datagen.DamageTypeGen;
import dev.su5ed.mffs.datagen.DamageTypeTagsGen;
import dev.su5ed.mffs.datagen.ItemModelGen;
import dev.su5ed.mffs.datagen.ItemTagsGen;
import dev.su5ed.mffs.datagen.LootTableGen;
import dev.su5ed.mffs.datagen.PackMetadataGen;
import dev.su5ed.mffs.datagen.RecipesGen;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="mffs", bus=EventBusSubscriber.Bus.MOD)
public final class ModDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, DamageTypeGen::bootstrap);
        DatapackBuiltinEntriesProvider entriesProvider = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), builder, Set.of("mffs")));
        CompletableFuture registries = entriesProvider.getRegistryProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGen(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGen(output, helper));
        BlockTagsGen blockTags = new BlockTagsGen(output, registries, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGen(output, registries, blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesGen(output, registries));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGen.ModBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(LootTableGen.ModItemLoot::new, LootContextParamSets.EMPTY)), registries));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, registries, helper, List.of(new AdvancementsGen())));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagsGen(output, registries, helper));
        generator.addProvider(true, (DataProvider)PackMetadataGen.create(output));
    }

    private ModDataGen() {
    }
}

