/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.api.ForceFieldBlock;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.network.InitialDataRequestPacket;
import dev.su5ed.mffs.render.BlockEntityRenderDelegate;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public class ForceFieldBlockEntity
extends BlockEntity {
    private BlockPos projector;
    private BlockState camouflage;
    private int clientBlockLight;

    public ForceFieldBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get(), pos, state);
    }

    public int getClientBlockLight() {
        return this.clientBlockLight;
    }

    public void setProjector(BlockPos position) {
        this.projector = position;
        this.setChanged();
    }

    public BlockState getCamouflage() {
        return this.camouflage;
    }

    public void setCamouflage(BlockState camouflage) {
        this.camouflage = camouflage;
        this.setChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide) {
            InitialDataRequestPacket packet = new InitialDataRequestPacket(this.worldPosition);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.camouflage != null) {
                BlockEntityRenderDelegate.INSTANCE.putDelegateFor(this, this.camouflage);
            }
        }
    }

    public void setRemoved() {
        if (this.level.isClientSide) {
            BlockEntityRenderDelegate.INSTANCE.removeDelegateOf(this);
        }
        super.setRemoved();
    }

    public ModelData getModelData() {
        if (this.camouflage != null) {
            return ModelData.builder().with(ForceFieldBlock.CAMOUFLAGE_BLOCK, (Object)this.camouflage).build();
        }
        return super.getModelData();
    }

    public Optional<Projector> getProjector() {
        return this.projector != null ? Optional.ofNullable((Projector)this.level.getCapability(ModCapabilities.PROJECTOR, this.projector, null)) : Optional.empty();
    }

    public CompoundTag getCustomUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        if (this.projector != null) {
            tag.put("projector", NbtUtils.writeBlockPos((BlockPos)this.projector));
        }
        int clientBlockLight = this.getProjector().map(projector -> Math.round((float)Math.min(projector.getModuleCount(ModModules.GLOW), 64) / 64.0f * 15.0f)).orElse(0);
        tag.putInt("clientBlockLight", clientBlockLight);
        return tag;
    }

    public void handleCustomUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.loadAdditional(tag, provider);
        this.projector = NbtUtils.readBlockPos((CompoundTag)tag, (String)"projector").orElse(null);
        this.clientBlockLight = tag.getInt("clientBlockLight");
        this.updateRenderClient();
        this.level.getLightEngine().checkBlock(this.worldPosition);
        if (this.camouflage != null) {
            BlockEntityRenderDelegate.INSTANCE.putDelegateFor(this, this.camouflage);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.projector != null) {
            tag.put("projector", NbtUtils.writeBlockPos((BlockPos)this.projector));
        }
        if (this.camouflage != null) {
            tag.put("camouflage", (Tag)NbtUtils.writeBlockState((BlockState)this.camouflage));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        NbtUtils.readBlockPos((CompoundTag)tag, (String)"projector").ifPresent(p -> {
            this.projector = p;
        });
        if (tag.contains("camouflage")) {
            this.camouflage = NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("camouflage"));
        }
    }

    public void updateRenderClient() {
        this.requestModelDataUpdate();
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }
}

