/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyJsonCompatLoader
implements ResourceManagerReloadListener {
    private static final Logger logger = LoggerFactory.getLogger(LegacyJsonCompatLoader.class);
    private static final Gson gson = new Gson();
    private static final FileToIdConverter COMPAT_JSONS = FileToIdConverter.json((String)"craftingtweaks_compat");
    private final List<CraftingGridProvider> providersFromDataPacks = new ArrayList<CraftingGridProvider>();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        for (CraftingGridProvider craftingGridProvider : this.providersFromDataPacks) {
            CraftingTweaksAPI.unregisterCraftingGridProvider(craftingGridProvider);
        }
        this.providersFromDataPacks.clear();
        for (Map.Entry entry : COMPAT_JSONS.listMatchingResources(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    CraftingGridProvider gridProvider = LegacyJsonCompatLoader.load((ResourceLocation)entry.getKey(), (CraftingTweaksRegistrationData)gson.fromJson((Reader)reader, CraftingTweaksRegistrationData.class));
                    if (gridProvider == null) continue;
                    this.providersFromDataPacks.add(gridProvider);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error("Parsing error loading CraftingTweaks data file at {}", entry.getKey(), (Object)e);
            }
        }
    }

    private static boolean isCompatEnabled(String modId) {
        return !CraftingTweaksConfig.getActive().client.disabledAddons.contains(modId);
    }

    private static CraftingGridProvider load(ResourceLocation resourceId, CraftingTweaksRegistrationData data) {
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId) || !LegacyJsonCompatLoader.isCompatEnabled(modId) || !data.isEnabled()) {
            return null;
        }
        CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
        if (gridProvider != null) {
            CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
            logger.info("Data pack file {} has registered {} of {} with CraftingTweaks", new Object[]{resourceId, data.getContainerClass(), modId});
        }
        return gridProvider;
    }
}

