/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningPedestalTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AwakeningPedestalBlock
extends BaseTileEntityBlock {
    public static final VoxelShape PEDESTAL_SHAPE = VoxelShapeBuilder.fromShapes((VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.3125, (double)0.125, (double)0.3125), Shapes.box((double)0.6875, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.3125), Shapes.box((double)0.125, (double)0.0, (double)0.6875, (double)0.3125, (double)0.125, (double)0.875), Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.25, (double)0.8125), Shapes.box((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.875, (double)0.75), Shapes.box((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.3125), Shapes.box((double)0.1875, (double)0.875, (double)0.6875, (double)0.8125, (double)1.0, (double)0.8125), Shapes.box((double)0.1875, (double)0.875, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875), Shapes.box((double)0.6875, (double)0.875, (double)0.3125, (double)0.8125, (double)1.0, (double)0.6875), Shapes.box((double)0.8125, (double)0.6875, (double)0.3125, (double)0.8125, (double)0.875, (double)0.6875), Shapes.box((double)0.1875, (double)0.6875, (double)0.3125, (double)0.1875, (double)0.875, (double)0.6875), Shapes.box((double)0.3125, (double)0.6875, (double)0.1875, (double)0.6875, (double)0.875, (double)0.1875), Shapes.box((double)0.3125, (double)0.6875, (double)0.8125, (double)0.6875, (double)0.875, (double)0.8125)}).build();

    public AwakeningPedestalBlock() {
        super(SoundType.STONE, 10.0f, 12.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AwakeningPedestalTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof AwakeningPedestalTileEntity) {
            AwakeningPedestalTileEntity pedestal = (AwakeningPedestalTileEntity)tile;
            BaseItemStackHandler inventory = pedestal.getInventory();
            ItemStack input = inventory.getStackInSlot(0);
            ItemStack held = player.getItemInHand(hand);
            if (input.isEmpty() && !held.isEmpty()) {
                inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                player.setItemInHand(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!input.isEmpty()) {
                inventory.setStackInSlot(0, ItemStack.EMPTY);
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), input);
                item.setNoPickUpDelay();
                level.addFreshEntity((Entity)item);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof AwakeningPedestalTileEntity) {
            AwakeningPedestalTileEntity pedestal = (AwakeningPedestalTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)pedestal.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PEDESTAL_SHAPE;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }
}

