/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HealthBoostAugment
extends Augment {
    private static final ResourceLocation ATTRIBUTE_ID = MysticalAgriculture.resource("health_boost_augment");
    private final int amplifier;

    public HealthBoostAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.ARMOR), HealthBoostAugment.getColor(12984891, tier), HealthBoostAugment.getColor(3867650, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onPlayerTick(Level level, Player player, AbilityCache cache) {
        if (!cache.isCached(this, player)) {
            AttributeInstance health = player.getAttribute(Attributes.MAX_HEALTH);
            if (health == null) {
                return;
            }
            int boost = 4 * this.amplifier;
            AttributeModifier modifier = health.getModifier(ATTRIBUTE_ID);
            if (modifier != null) {
                if ((double)boost < modifier.amount()) {
                    return;
                }
                health.removeModifier(modifier);
                cache.getCachedAbilities(player).forEach(c -> {
                    Augment augment = AugmentRegistry.getInstance().getAugmentById(ResourceLocation.parse((String)c));
                    if (augment instanceof HealthBoostAugment && cache.isCached(augment, player)) {
                        cache.removeQuietly((String)c, player);
                    }
                });
            }
            health.addPermanentModifier(new AttributeModifier(ATTRIBUTE_ID, (double)boost, AttributeModifier.Operation.ADD_VALUE));
            cache.add(this, player, () -> {
                float max = player.getMaxHealth() - (float)boost;
                if (player.getHealth() > max) {
                    player.setHealth(max);
                }
                health.removeModifier(ATTRIBUTE_ID);
            });
        }
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

