/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public record Constraints(Set<WorldTier> tiers, Set<ResourceKey<Level>> dimensions, HolderSet<Biome> biomes, Set<String> gameStages) {
    public static final Constraints EMPTY = new Constraints(Set.of(), Set.of(), (HolderSet<Biome>)HolderSet.empty(), Set.of());
    public static final Codec<Constraints> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.setOf(WorldTier.CODEC).optionalFieldOf("tiers", Collections.emptySet()).forGetter(Constraints::tiers), (App)PlaceboCodecs.setOf((Codec)Level.RESOURCE_KEY_CODEC).optionalFieldOf("dimensions", Collections.emptySet()).forGetter(Constraints::dimensions), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes", (Object)HolderSet.empty()).forGetter(Constraints::biomes), (App)PlaceboCodecs.setOf((Codec)Codec.string((int)1, (int)256)).optionalFieldOf("stages", Collections.emptySet()).forGetter(Constraints::gameStages)).apply((Applicative)inst, Constraints::new));

    public static Constraints forDimension(ResourceKey<Level> key) {
        return new Constraints(Set.of(), Set.of(key), (HolderSet<Biome>)HolderSet.empty(), Set.of());
    }

    public static Constraints forBiomes(HolderLookup.RegistryLookup<Biome> registry, TagKey<Biome> key) {
        return new Constraints(Set.of(), Set.of(), (HolderSet<Biome>)registry.getOrThrow(key), Set.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(GenContext ctx) {
        if (!this.tiers.isEmpty()) {
            if (!this.tiers.contains((Object)ctx.tier())) return false;
        }
        if (!this.dimensions.isEmpty() && !this.dimensions.contains(ctx.dimension())) {
            return false;
        }
        if (this.biomes.size() != 0 && !this.biomes.contains(ctx.biome())) {
            return false;
        }
        if (this.gameStages.isEmpty()) return true;
        if (!this.gameStages.stream().anyMatch(ctx.stages()::contains)) return false;
        return true;
    }

    public static <T extends Constrained> Predicate<T> eval(GenContext ctx) {
        return t -> t.constraints().test(ctx);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<WorldTier> tiers = new LinkedHashSet<WorldTier>();
        private Set<ResourceKey<Level>> dimensions = new LinkedHashSet<ResourceKey<Level>>();
        private HolderSet<Biome> biomes = HolderSet.empty();
        private Set<String> gameStages = new LinkedHashSet<String>();

        public Builder tiers(WorldTier ... tiers) {
            for (WorldTier tier : tiers) {
                this.tiers.add(tier);
            }
            return this;
        }

        @SafeVarargs
        public final Builder dimensions(ResourceKey<Level> ... dimensions) {
            for (ResourceKey<Level> dim : dimensions) {
                this.dimensions.add(dim);
            }
            return this;
        }

        public Builder biomes(HolderSet<Biome> biomes) {
            this.biomes = biomes;
            return this;
        }

        public Builder biomes(HolderLookup.RegistryLookup<Biome> registry, TagKey<Biome> key) {
            return this.biomes((HolderSet<Biome>)registry.getOrThrow(key));
        }

        public Builder gameStages(String ... gameStages) {
            for (String stage : gameStages) {
                this.gameStages.add(stage);
            }
            return this;
        }

        public Constraints build() {
            return new Constraints(this.tiers, this.dimensions, this.biomes, this.gameStages);
        }
    }

    public static interface Constrained {
        public Constraints constraints();
    }
}

