/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.mixin.BaseSpawnerAccessor;
import dev.shadowsoffire.apotheosis.util.PresetSpawnerStats;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class RogueSpawner
implements CodecProvider<RogueSpawner>,
WeightedDynamicRegistry.ILuckyWeighted {
    public static final Codec<RogueSpawner> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("weight").forGetter(RogueSpawner::getWeight), (App)PresetSpawnerStats.CODEC.fieldOf("stats").forGetter(RogueSpawner::getStats), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(RogueSpawner::getLootTableId), (App)SimpleWeightedRandomList.wrappedCodec((Codec)SpawnData.CODEC).fieldOf("spawn_potentials").forGetter(s -> s.spawnPotentials)).apply((Applicative)inst, RogueSpawner::new));
    protected final int weight;
    protected final PresetSpawnerStats stats;
    protected final ResourceKey<LootTable> lootTable;
    protected final SimpleWeightedRandomList<SpawnData> spawnPotentials;

    public RogueSpawner(int weight, PresetSpawnerStats stats, ResourceKey<LootTable> lootTable, SimpleWeightedRandomList<SpawnData> potentials) {
        this.weight = weight;
        this.stats = stats;
        this.lootTable = lootTable;
        this.spawnPotentials = potentials;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return 0.0f;
    }

    public PresetSpawnerStats getStats() {
        return this.stats;
    }

    public ResourceKey<LootTable> getLootTableId() {
        return this.lootTable;
    }

    public void place(WorldGenLevel level, BlockPos pos, RandomSource rand) {
        level.setBlock(pos, Blocks.SPAWNER.defaultBlockState(), 2);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ApothSpawnerTile) {
            ApothSpawnerTile spawner = (ApothSpawnerTile)blockEntity;
            this.stats.apply(spawner);
            spawner.getSpawner().spawnPotentials = this.spawnPotentials;
            ((BaseSpawnerAccessor)spawner.getSpawner()).callSetNextSpawnData(null, pos, (SpawnData)this.spawnPotentials.getRandomValue(rand).get());
            level.setBlock(pos.below(), Blocks.CHEST.defaultBlockState(), 2);
            ResourceKey<LootTable> realLootTable = rand.nextFloat() <= AdventureConfig.spawnerValueChance ? Apoth.LootTables.CHEST_VALUABLE : this.lootTable;
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)rand, (BlockPos)pos.below(), realLootTable);
            Block cover = BuiltInRegistries.BLOCK.getRandomElementOf(Apoth.Tags.ROGUE_SPAWNER_COVERS, rand).map(Holder::value).orElse(Blocks.STONE);
            level.setBlock(pos.above(), cover.defaultBlockState(), 2);
            for (Direction f : Direction.Plane.HORIZONTAL) {
                if (!level.getBlockState(pos.relative(f)).isAir()) continue;
                BooleanProperty side = (BooleanProperty)Blocks.VINE.getStateDefinition().getProperty(f.getOpposite().getName());
                level.setBlock(pos.relative(f), (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public Codec<? extends RogueSpawner> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected int weight;
        protected PresetSpawnerStats stats;
        protected ResourceKey<LootTable> lootTable;
        protected SimpleWeightedRandomList.Builder<SpawnData> spawnPotentials = SimpleWeightedRandomList.builder();

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder stats(UnaryOperator<PresetSpawnerStats.Builder> config) {
            this.stats = ((PresetSpawnerStats.Builder)config.apply(PresetSpawnerStats.builder())).build();
            return this;
        }

        public Builder lootTable(ResourceKey<LootTable> key) {
            this.lootTable = key;
            return this;
        }

        public Builder spawnData(int weight, SpawnData data) {
            this.spawnPotentials.add((Object)data, weight);
            return this;
        }

        public Builder spawnData(int weight, CompoundTag data) {
            return this.spawnData(weight, new SpawnData(data, Optional.empty(), Optional.empty()));
        }

        public RogueSpawner build() {
            Preconditions.checkArgument((this.weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than 0");
            Preconditions.checkNotNull((Object)this.stats, (Object)"Stats must be set");
            Preconditions.checkNotNull(this.lootTable, (Object)"Loot Table must be set");
            SimpleWeightedRandomList spawnList = this.spawnPotentials.build();
            Preconditions.checkArgument((!spawnList.isEmpty() ? 1 : 0) != 0, (Object)"At least one spawn potential must be provided");
            return new RogueSpawner(this.weight, this.stats, this.lootTable, (SimpleWeightedRandomList<SpawnData>)spawnList);
        }
    }
}

