/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.util.RadialUtil;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class RadialBonus
extends GemBonus {
    public static final Codec<RadialBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(RadialBonus.gemClass(), (App)Purity.mapCodec(RadialUtil.RadialData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, RadialBonus::new));
    public static final ResourceLocation GEM_RADIAL_DATA_CACHED_OBJECT = Apotheosis.loc("gem_radial_data");
    protected final Map<Purity, RadialUtil.RadialData> values;

    public RadialBonus(GemClass gemClass, Map<Purity, RadialUtil.RadialData> values) {
        super(gemClass);
        this.values = values;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        RadialUtil.RadialData data = this.values.get(gem.purity());
        return Component.translatable((String)"affix.apotheosis:breaker/effect/radial.desc", (Object[])new Object[]{data.x(), data.y()}).withStyle(ChatFormatting.YELLOW);
    }

    public static void onBreak(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        RadialUtil.RadialData data = RadialBonus.getRadialData(player.getMainHandItem());
        if (data != null) {
            RadialUtil.attemptRadialMining(e, data);
        }
    }

    @Nullable
    public static RadialUtil.RadialData getRadialData(ItemStack tool) {
        return (RadialUtil.RadialData)CachedObject.CachedObjectSource.getOrCreate((ItemStack)tool, (ResourceLocation)GEM_RADIAL_DATA_CACHED_OBJECT, RadialBonus::getRadialDataImpl, (ToIntFunction)CachedObject.hashComponents((DataComponentType[])new DataComponentType[]{Apoth.Components.SOCKETED_GEMS, Apoth.Components.SOCKETS}));
    }

    @Nullable
    private static RadialUtil.RadialData getRadialDataImpl(ItemStack tool) {
        GemInstance inst;
        if (tool.has(Apoth.Components.SOCKETED_GEMS) && (inst = (GemInstance)SocketHelper.getGems(tool).streamValidGems().filter(g -> g.getBonus().orElse(null) instanceof RadialBonus).findFirst().orElse(null)) != null && inst.isValid()) {
            return ((RadialBonus)inst.getBonus().get()).values.get(inst.purity());
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, RadialUtil.RadialData> values = new LinkedHashMap<Purity, RadialUtil.RadialData>();

        public Builder value(Purity rarity, int x, int y, int xOff, int yOff) {
            RadialUtil.RadialData data = new RadialUtil.RadialData(x, y, xOff, yOff);
            this.values.put(rarity, data);
            return this;
        }

        @Override
        public RadialBonus build(GemClass gClass) {
            return new RadialBonus(gClass, this.values);
        }
    }
}

