/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class AllStatsBonus
extends GemBonus {
    public static Codec<AllStatsBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AllStatsBonus.gemClass(), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)Purity.mapCodec(Codec.FLOAT).fieldOf("values").forGetter(a -> a.values), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ATTRIBUTE).fieldOf("attributes").forGetter(a -> a.attributes)).apply((Applicative)inst, AllStatsBonus::new));
    protected final AttributeModifier.Operation operation;
    protected final Map<Purity, Float> values;
    protected final HolderSet<Attribute> attributes;

    public AllStatsBonus(GemClass gemClass, AttributeModifier.Operation op, Map<Purity, Float> values, HolderSet<Attribute> attributes) {
        super(gemClass);
        this.operation = op;
        this.values = values;
        this.attributes = attributes;
    }

    @Override
    public void addModifiers(GemInstance inst, StackAttributeModifiersEvent event) {
        int idx = 0;
        for (Holder attr : this.attributes) {
            ResourceLocation id = AllStatsBonus.makeUniqueId(inst, "" + idx++);
            AttributeModifier modif = new AttributeModifier(id, (double)this.values.get(inst.purity()).floatValue(), this.operation);
            event.addModifier(attr, modif, inst.category().getSlots());
        }
    }

    @Override
    public void skipModifierIds(GemInstance inst, Consumer<ResourceLocation> skip) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            skip.accept(AllStatsBonus.makeUniqueId(inst, "" + i));
        }
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        float value = this.values.get(inst.purity()).floatValue();
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(value * 100.0f)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, Float> values = new LinkedHashMap<Purity, Float>();
        private final List<Holder<Attribute>> attributes = new ArrayList<Holder<Attribute>>();
        private AttributeModifier.Operation operation;

        private Builder() {
        }

        @SafeVarargs
        public final Builder attributes(Holder<Attribute> ... attributes) {
            for (Holder<Attribute> a : attributes) {
                this.attributes.add(a);
            }
            return this;
        }

        public Builder op(AttributeModifier.Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder value(Purity purity, float value) {
            this.values.put(purity, Float.valueOf(value));
            return this;
        }

        @Override
        public AllStatsBonus build(GemClass gClass) {
            return new AllStatsBonus(gClass, this.operation, this.values, (HolderSet<Attribute>)HolderSet.direct(this.attributes));
        }
    }
}

