/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.AttributeBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.DamageReductionBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.DurabilityBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.EnchantmentBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.MobEffectBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.MultiAttrBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.AllStatsBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.BloodyArrowBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.DropTransformBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.FrozenDropsBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.LeechBlockBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.MageSlayerBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.OmneticBonus;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.RadialBonus;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;

public abstract class GemBonus
implements CodecProvider<GemBonus> {
    public static final CodecMap<GemBonus> CODEC = new CodecMap("Gem Bonus");
    protected final GemClass gemClass;

    public GemBonus(GemClass gemClass) {
        this.gemClass = gemClass;
    }

    public abstract boolean supports(Purity var1);

    public abstract Component getSocketBonusTooltip(GemView var1, AttributeTooltipContext var2);

    public void addModifiers(GemInstance inst, StackAttributeModifiersEvent event) {
    }

    public float getDamageProtection(GemInstance inst, DamageSource source) {
        return 0.0f;
    }

    public float getDamageBonus(GemInstance inst, Entity target) {
        return 0.0f;
    }

    public void doPostAttack(GemInstance inst, LivingEntity user, @Nullable Entity target) {
    }

    public void doPostHurt(GemInstance inst, LivingEntity user, DamageSource source) {
    }

    public void onProjectileFired(GemInstance inst, LivingEntity user, Projectile proj) {
    }

    @Nullable
    public InteractionResult onItemUse(GemInstance inst, UseOnContext ctx) {
        return null;
    }

    public void onProjectileImpact(GemInstance inst, Projectile proj, HitResult res) {
    }

    public float onShieldBlock(GemInstance inst, LivingEntity entity, DamageSource source, float amount) {
        return amount;
    }

    public void onBlockBreak(GemInstance inst, Player player, LevelAccessor level, BlockPos pos, BlockState state) {
    }

    public float getDurabilityBonusPercentage(GemInstance inst) {
        return 0.0f;
    }

    public float onHurt(GemInstance inst, DamageSource src, LivingEntity user, float amount) {
        return amount;
    }

    public void getEnchantmentLevels(GemInstance inst, GetEnchantmentLevelEvent event) {
    }

    public void modifyLoot(GemInstance inst, ObjectArrayList<ItemStack> loot, LootContext ctx) {
    }

    public void skipModifierIds(GemInstance inst, Consumer<ResourceLocation> skip) {
    }

    public final ResourceLocation getTypeKey() {
        return CODEC.getKey(this.getCodec());
    }

    public final GemClass getGemClass() {
        return this.gemClass;
    }

    protected static ResourceLocation makeUniqueId(GemView view, String salt) {
        String path = view.gem().getId().getPath() + "_modifier_";
        if (view instanceof GemInstance) {
            GemInstance inst = (GemInstance)view;
            path = path + inst.category().getSlots().id().toShortLanguageKey() + "_" + inst.slot();
        }
        return ResourceLocation.fromNamespaceAndPath((String)view.gem().getId().getNamespace(), (String)(path + salt));
    }

    protected static ResourceLocation makeUniqueId(GemView inst) {
        return GemBonus.makeUniqueId(inst, "");
    }

    public static void initCodecs() {
        GemBonus.register("attribute", AttributeBonus.CODEC);
        GemBonus.register("multi_attribute", MultiAttrBonus.CODEC);
        GemBonus.register("durability", DurabilityBonus.CODEC);
        GemBonus.register("damage_reduction", DamageReductionBonus.CODEC);
        GemBonus.register("enchantment", EnchantmentBonus.CODEC);
        GemBonus.register("bloody_arrow", BloodyArrowBonus.CODEC);
        GemBonus.register("leech_block", LeechBlockBonus.CODEC);
        GemBonus.register("all_stats", AllStatsBonus.CODEC);
        GemBonus.register("drop_transform", DropTransformBonus.CODEC);
        GemBonus.register("mageslayer", MageSlayerBonus.CODEC);
        GemBonus.register("mob_effect", MobEffectBonus.CODEC);
        GemBonus.register("frozen_drops", FrozenDropsBonus.CODEC);
        GemBonus.register("omnetic", OmneticBonus.CODEC);
        GemBonus.register("radial", RadialBonus.CODEC);
    }

    protected static <T extends GemBonus> App<RecordCodecBuilder.Mu<T>, GemClass> gemClass() {
        return GemClass.CODEC.fieldOf("gem_class").forGetter(GemBonus::getGemClass);
    }

    private static void register(String id, Codec<? extends GemBonus> codec) {
        CODEC.register(Apotheosis.loc(id), codec);
    }

    public static abstract class Builder {
        public abstract GemBonus build(GemClass var1);
    }
}

