/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtraGemBonusRegistry
extends DynamicRegistry<ExtraGemBonus> {
    public static final ExtraGemBonusRegistry INSTANCE = new ExtraGemBonusRegistry();
    protected Multimap<DynamicHolder<Gem>, ExtraGemBonus> extraBonuses = HashMultimap.create();

    public ExtraGemBonusRegistry() {
        super(Apotheosis.LOGGER, "extra_gem_bonuses", true, false);
    }

    protected void beginReload(DynamicRegistry.ReloadType type) {
        super.beginReload(type);
        this.extraBonuses = HashMultimap.create();
    }

    protected void onReload(DynamicRegistry.ReloadType type) {
        super.onReload(type);
        for (ExtraGemBonus extraBonus : this.getValues()) {
            this.extraBonuses.put(extraBonus.gem, (Object)extraBonus);
        }
    }

    public static Collection<ExtraGemBonus> getBonusesFor(DynamicHolder<Gem> gem) {
        return ExtraGemBonusRegistry.INSTANCE.extraBonuses.get(gem);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("extra_gem_bonus"), ExtraGemBonus.CODEC);
    }

    public record ExtraGemBonus(DynamicHolder<Gem> gem, List<GemBonus> bonuses) implements CodecProvider<ExtraGemBonus>
    {
        public static final Codec<ExtraGemBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemRegistry.INSTANCE.holderCodec().fieldOf("gem").forGetter(ExtraGemBonus::gem), (App)GemBonus.CODEC.listOf().fieldOf("bonuses").forGetter(ExtraGemBonus::bonuses)).apply((Applicative)inst, ExtraGemBonus::new));

        public Codec<? extends ExtraGemBonus> getCodec() {
            return CODEC;
        }

        public static Builder builder(DynamicHolder<Gem> gem) {
            return new Builder(gem);
        }

        public static class Builder {
            protected final DynamicHolder<Gem> gem;
            protected List<GemBonus> bonuses = new ArrayList<GemBonus>();

            public Builder(DynamicHolder<Gem> gem) {
                this.gem = gem;
            }

            public Builder bonus(LootCategory cat, GemBonus.Builder builder) {
                return this.bonus(new GemClass(cat), builder);
            }

            public Builder bonus(GemClass gClass, GemBonus.Builder builder) {
                this.bonuses.add(builder.build(gClass));
                return this;
            }

            public Builder bonus(GemBonus bonus) {
                this.bonuses.add(bonus);
                return this;
            }

            public ExtraGemBonus build() {
                return new ExtraGemBonus(this.gem, this.bonuses);
            }
        }
    }
}

