/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.net;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.client.AdventureModuleClient;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.mutable.MutableInt;

public record BossSpawnPayload(BlockPos pos, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BossSpawnPayload> TYPE = new CustomPacketPayload.Type(Apotheosis.loc("boss_spawn"));
    public static final StreamCodec<ByteBuf, BossSpawnPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BossSpawnPayload::pos, (StreamCodec)ByteBufCodecs.INT, BossSpawnPayload::color, BossSpawnPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record BossSpawnData(BlockPos pos, int color, MutableInt ticks) {
    }

    public static class Provider
    implements PayloadProvider<BossSpawnPayload> {
        public CustomPacketPayload.Type<BossSpawnPayload> getType() {
            return TYPE;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, BossSpawnPayload> getCodec() {
            return CODEC;
        }

        public void handle(BossSpawnPayload msg, IPayloadContext ctx) {
            AdventureModuleClient.onBossSpawn(msg.pos, msg.color);
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }

        public String getVersion() {
            return "1";
        }
    }
}

