/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record WorldTierCondition(Set<WorldTier> tiers) implements LootItemCondition
{
    public static final MapCodec<WorldTierCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)PlaceboCodecs.setOf(WorldTier.CODEC).fieldOf("tiers").forGetter(WorldTierCondition::tiers)).apply((Applicative)inst, WorldTierCondition::new));

    public LootItemConditionType getType() {
        return Apoth.LootConditions.HAS_WORLD_TIER;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ATTACKING_ENTITY);
    }

    public boolean test(LootContext ctx) {
        GenContext gCtx = GenContext.forLoot(ctx);
        return gCtx != null && this.tiers.contains((Object)gCtx.tier());
    }

    public static LootItemCondition.Builder onlyInTiers(WorldTier ... tiers) {
        LinkedHashSet<WorldTier> set = new LinkedHashSet<WorldTier>();
        for (WorldTier tier : tiers) {
            set.add(tier);
        }
        return () -> new WorldTierCondition(set);
    }
}

