/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class WorldTierCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_WORLD_TIER = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(WorldTier.values()).map(WorldTier::getSerializedName), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"set_world_tier").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_WORLD_TIER).executes(c -> {
            ServerPlayer p = EntityArgument.getPlayer((CommandContext)c, (String)"target_player");
            WorldTier tier = WorldTier.valueOf(StringArgumentType.getString((CommandContext)c, (String)"tier").toUpperCase(Locale.ROOT));
            WorldTier.setTier((Player)p, tier);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> WorldTierCommand.lambda$register$2((Player)p, tier), true);
            return 0;
        }))));
    }

    private static /* synthetic */ Component lambda$register$2(Player p, WorldTier tier) {
        return Component.translatable((String)"Set %s's world tier to %s", (Object[])new Object[]{p.getName(), tier.getSerializedName()});
    }
}

