/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.shadowsoffire.apotheosis.client.ApothRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class BeamRenderer {
    public static void renderBeaconBeam(PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation beamLocation, ResourceLocation glowLocation, float partialTick, float textureScale, long gameTime, float yOffset, float height, int colorBot, int colorTop, float beamRadius, float glowRadius) {
        if (height < 0.0f) {
            return;
        }
        float i = yOffset + height;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(gameTime, 40) + partialTick;
        float f1 = height < 0.0f ? f : -f;
        float f2 = Mth.frac((float)(f1 * 0.2f - (float)Mth.floor((float)(f1 * 0.1f))));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(f * 2.25f - 45.0f));
        float f3 = 0.0f;
        float f5 = 0.0f;
        float f6 = -beamRadius;
        float f9 = -beamRadius;
        float f12 = -1.0f + f2;
        float f13 = height * textureScale * (0.5f / beamRadius) + f12;
        BeamRenderer.renderPart(poseStack, bufferSource.getBuffer(ApothRenderTypes.affixBeam(beamLocation, true)), colorBot, colorTop, yOffset, i, 0.0f, beamRadius, beamRadius, 0.0f, f6, 0.0f, 0.0f, f9, 0.0f, 1.0f, f13, f12);
        poseStack.popPose();
        f3 = -glowRadius;
        float f4 = -glowRadius;
        f5 = -glowRadius;
        f6 = -glowRadius;
        f12 = -1.0f + f2;
        f13 = height * textureScale + f12;
        BeamRenderer.renderPart(poseStack, bufferSource.getBuffer(ApothRenderTypes.affixBeam(glowLocation, true)), FastColor.ARGB32.color((int)(FastColor.ARGB32.alpha((int)colorBot) / 2), (int)colorBot), FastColor.ARGB32.color((int)(FastColor.ARGB32.alpha((int)colorTop) / 2), (int)colorTop), yOffset, i, f3, f4, glowRadius, f5, f6, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f13, f12);
        poseStack.popPose();
    }

    private static void renderPart(PoseStack poseStack, VertexConsumer consumer, int colorBot, int colorTop, float minY, float maxY, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float minU, float maxU, float minV, float maxV) {
        PoseStack.Pose posestack$pose = poseStack.last();
        BeamRenderer.renderQuad(posestack$pose, consumer, colorBot, colorTop, minY, maxY, x1, z1, x2, z2, minU, maxU, minV, maxV);
        BeamRenderer.renderQuad(posestack$pose, consumer, colorBot, colorTop, minY, maxY, x4, z4, x3, z3, minU, maxU, minV, maxV);
        BeamRenderer.renderQuad(posestack$pose, consumer, colorBot, colorTop, minY, maxY, x2, z2, x4, z4, minU, maxU, minV, maxV);
        BeamRenderer.renderQuad(posestack$pose, consumer, colorBot, colorTop, minY, maxY, x3, z3, x1, z1, minU, maxU, minV, maxV);
    }

    private static void renderQuad(PoseStack.Pose pose, VertexConsumer consumer, int colorBot, int colorTop, float minY, float maxY, float minX, float minZ, float maxX, float maxZ, float minU, float maxU, float minV, float maxV) {
        BeamRenderer.addVertex(pose, consumer, colorTop, maxY, minX, minZ, maxU, minV);
        BeamRenderer.addVertex(pose, consumer, colorBot, minY, minX, minZ, maxU, maxV);
        BeamRenderer.addVertex(pose, consumer, colorBot, minY, maxX, maxZ, minU, maxV);
        BeamRenderer.addVertex(pose, consumer, colorTop, maxY, maxX, maxZ, minU, minV);
    }

    private static void addVertex(PoseStack.Pose pose, VertexConsumer consumer, int color, float y, float x, float z, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

