/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class EnlightenedAffix
extends Affix {
    public static final Codec<EnlightenedAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(EnlightenedAffix.affixDef(), (App)LootRarity.mapCodec(StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, EnlightenedAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public EnlightenedAffix(AffixDefinition def, Map<LootRarity, StepFunction> values) {
        super(def);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{this.getTrueLevel(inst.getRarity(), inst.level())});
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        MutableComponent minComp = Component.literal((String)EnlightenedAffix.fmt(this.getTrueLevel(inst.getRarity(), 0.0f)));
        MutableComponent maxComp = Component.literal((String)EnlightenedAffix.fmt(this.getTrueLevel(inst.getRarity(), 1.0f)));
        return comp.append((Component)EnlightenedAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    @Override
    public InteractionResult onItemUse(AffixInstance inst, UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (AdventureConfig.torchItem.useOn(ctx).consumesAction()) {
            if (ctx.getItemInHand().isEmpty()) {
                ctx.getItemInHand().grow(1);
            }
            int cost = this.getTrueLevel(inst.getRarity(), inst.level());
            player.getItemInHand(ctx.getHand()).hurtAndBreak(cost, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
            return InteractionResult.SUCCESS;
        }
        return super.onItemUse(inst, ctx);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    @Override
    public boolean isLevelIndependent(AffixInstance inst) {
        return this.values.get(inst.getRarity()).isConstant();
    }

    protected int getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).getInt(level);
    }
}

