/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.cut;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ImmersiveEngineeringSawmillProcessor
extends Processor<RecipeInput, SawmillRecipe> {
    public ImmersiveEngineeringSawmillProcessor(MinecraftServer server) {
        super(server, (RecipeType)IERecipeTypes.SAWMILL.type().get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.cutRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(SawmillRecipe recipe) {
        return recipe.input;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends SawmillRecipe> recipeHolder, Ingredient ingredient) {
        SawmillRecipe recipe = (SawmillRecipe)recipeHolder.value();
        RecipeWrapper.Cut wrapper = new RecipeWrapper.Cut(recipeHolder.id(), ingredient).withItems(recipe.output.get());
        for (ItemStack output : recipe.secondaryOutputs.get()) {
            wrapper = wrapper.withItems(output.copy());
        }
        for (ItemStack output : recipe.secondaryStripping.get()) {
            wrapper = wrapper.withItems(output.copy());
        }
        return wrapper.asHolder();
    }
}

