/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.cut;

import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class FarmersDelightCuttingBoardProcessor
extends Processor<CuttingBoardRecipeInput, CuttingBoardRecipe> {
    public FarmersDelightCuttingBoardProcessor(MinecraftServer server) {
        super(server, (RecipeType)ModRecipeTypes.CUTTING.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.cutRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(CuttingBoardRecipe recipe) {
        NonNullList ingredientList = recipe.getIngredients();
        if (ingredientList.size() != 1) {
            return null;
        }
        return (Ingredient)ingredientList.getFirst();
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends CuttingBoardRecipe> recipeHolder, Ingredient ingredient) {
        RecipeWrapper.Cut wrapper = new RecipeWrapper.Cut(recipeHolder.id(), ingredient);
        for (ItemStack output : ((CuttingBoardRecipe)recipeHolder.value()).getResults()) {
            wrapper = wrapper.withItems(output);
        }
        return wrapper.asHolder();
    }
}

