/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors;

import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.mixin.RecipeManagerAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public abstract class Processor<I extends RecipeInput, T extends Recipe<I>> {
    public final MinecraftServer server;
    public final RecipeType<? extends T> recipeType;

    public Processor(MinecraftServer server, RecipeType<? extends T> recipeType) {
        this.server = server;
        this.recipeType = recipeType;
    }

    public RecipeManager recipeManager() {
        return this.server.getRecipeManager();
    }

    public RegistryAccess registryAccess() {
        return this.server.registryAccess();
    }

    public abstract Set<Item> getExistingInputs();

    @Nullable
    public abstract Ingredient getIngredient(T var1);

    public void processRecipes() {
        Set<Item> existing = this.getExistingInputs();
        List<RecipeHolder<T>> recipes = this.getSortedRecipes();
        Object2ObjectOpenHashMap toReplace = new Object2ObjectOpenHashMap(((RecipeManagerAccessor)this.recipeManager()).getByName());
        for (RecipeHolder<T> holder : recipes) {
            RecipeHolder<?> toAdd;
            Ingredient usable;
            Recipe recipe;
            Ingredient ingredient;
            if (Config.isExcluded(holder.id()) || (ingredient = this.getIngredient(recipe = holder.value())) == null || ingredient.isEmpty()) continue;
            if (!ingredient.isCustom()) {
                Ingredient.Value[] values = ingredient.getValues();
                if (values.length != 1) continue;
                Ingredient.Value value = values[0];
                if (value instanceof Ingredient.TagValue) {
                    RecipeHolder<?> toAdd2;
                    Ingredient.TagValue tag = (Ingredient.TagValue)value;
                    if (tag.getItems().isEmpty()) continue;
                    Ingredient flattened = Ingredient.of(tag.getItems().stream().filter(stack -> !stack.isEmpty() && stack.getCount() == 1 && !existing.contains(stack.getItem())));
                    if (flattened.getItems().length != tag.getItems().size()) {
                        if (flattened.getItems().length <= 0 || (toAdd2 = this.makeRecipe(existing, holder, flattened)) == null) continue;
                        toReplace.put(toAdd2.id(), toAdd2);
                        continue;
                    }
                    toAdd2 = this.makeRecipe(existing, holder, ingredient);
                    if (toAdd2 == null) continue;
                    toReplace.put(toAdd2.id(), toAdd2);
                    continue;
                }
                if (value instanceof Ingredient.ItemValue) {
                    RecipeHolder<?> toAdd3;
                    Ingredient.ItemValue item = (Ingredient.ItemValue)value;
                    if (item.item().isEmpty() || item.item().getCount() != 1 || existing.contains(item.item().getItem()) || (toAdd3 = this.makeRecipe(existing, holder, ingredient)) == null) continue;
                    toReplace.put(toAdd3.id(), toAdd3);
                    continue;
                }
            }
            if ((usable = Ingredient.of(Arrays.stream(ingredient.getItems()).filter(stack -> !stack.isEmpty() && stack.getCount() == 1 && !existing.contains(stack.getItem())))).getItems().length <= 0 || (toAdd = this.makeRecipe(existing, holder, usable)) == null) continue;
            toReplace.put(toAdd.id(), toAdd);
        }
        this.recipeManager().replaceRecipes(toReplace.values());
    }

    @Nullable
    public abstract RecipeHolder<?> processCommon(Set<Item> var1, RecipeHolder<? extends T> var2, Ingredient var3);

    @Nullable
    public RecipeHolder<?> makeRecipe(Set<Item> existing, RecipeHolder<? extends T> recipeHolder, Ingredient ingredient) {
        RecipeHolder<?> out = this.processCommon(existing, recipeHolder, ingredient);
        for (ItemStack input : ingredient.getItems()) {
            existing.add(input.getItem());
        }
        return out;
    }

    public List<? extends RecipeHolder<? extends T>> getSortedRecipes() {
        ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(this.recipeManager().getAllRecipesFor(this.recipeType));
        recipes.sort(Comparator.comparing(r -> r.id().toString()));
        return recipes;
    }
}

