/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification;

import com.google.common.base.Stopwatch;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.processors.crush.AE2InscriberProcesser;
import dev.qther.ars_unification.processors.crush.ActuallyAdditionsCrusherProcessor;
import dev.qther.ars_unification.processors.crush.EnderIOSAGMillProcessor;
import dev.qther.ars_unification.processors.crush.ImmersiveEngineeringCrusherProcessor;
import dev.qther.ars_unification.processors.crush.IntegratedDynamicsSqueezerProcessor;
import dev.qther.ars_unification.processors.crush.MekanismCrusherProcessor;
import dev.qther.ars_unification.processors.crush.ModernIndustrializationMaceratorProcessor;
import dev.qther.ars_unification.processors.crush.OccultismCrusherProcessor;
import dev.qther.ars_unification.processors.cut.FarmersDelightCuttingBoardProcessor;
import dev.qther.ars_unification.processors.cut.ImmersiveEngineeringSawmillProcessor;
import dev.qther.ars_unification.processors.cut.MekanismSawmillProcessor;
import dev.qther.ars_unification.processors.cut.ModernIndustrializationCuttingMachineProcessor;
import dev.qther.ars_unification.processors.press.AE2CircuitPrintingProcesser;
import dev.qther.ars_unification.processors.press.ModernIndustrializationCompressorProcessor;
import dev.qther.ars_unification.recipe.CutRecipe;
import dev.qther.ars_unification.recipe.PressRecipe;
import dev.qther.ars_unification.setup.registry.AURecipeRegistry;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="ars_unification")
public class ArsUnification {
    public static final String MODID = "ars_unification";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ars_unification");
    private static final List<ProcessorInfo> PROCESSORS = new ArrayList<ProcessorInfo>();
    private static boolean processorsRegistered = false;

    public ArsUnification(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
        AURecipeRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        AURecipeRegistry.RECIPE_TYPES.register(modEventBus);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDatapackSync(OnDatapackSyncEvent event) {
        ArsUnification.processRecipes(event.getPlayerList().getServer());
    }

    public static void processRecipes(MinecraftServer server) {
        if (!Config.SPEC.isLoaded()) {
            return;
        }
        ModList mods = ModList.get();
        Config cfg = Config.CONFIG;
        if (!processorsRegistered) {
            processorsRegistered = true;
            PROCESSORS.add(new ProcessorInfo("mekanism", cfg.MEKANISM_CRUSHER, MekanismCrusherProcessor::new));
            PROCESSORS.add(new ProcessorInfo("enderio_machines", cfg.ENDERIO_SAG_MILL, EnderIOSAGMillProcessor::new));
            PROCESSORS.add(new ProcessorInfo("integrateddynamics", cfg.INTEGRATEDDYNAMICS_SQUEEZER, IntegratedDynamicsSqueezerProcessor::new));
            PROCESSORS.add(new ProcessorInfo("actuallyadditions", cfg.ACTUALLYADDITIONS_CRUSHER, ActuallyAdditionsCrusherProcessor::new));
            PROCESSORS.add(new ProcessorInfo("modern_industrialization", cfg.MODERN_INDUSTRIALIZATION_MACERATOR, ModernIndustrializationMaceratorProcessor::new));
            PROCESSORS.add(new ProcessorInfo("immersiveengineering", cfg.IMMERSIVE_ENGINEERING_CRUSHER, ImmersiveEngineeringCrusherProcessor::new));
            PROCESSORS.add(new ProcessorInfo("occultism", cfg.OCCULTISM_CRUSHER, OccultismCrusherProcessor::new));
            PROCESSORS.add(new ProcessorInfo("ae2", cfg.CRUSH_AE2_INSCRIBER, AE2InscriberProcesser::new));
            PROCESSORS.add(new ProcessorInfo("mekanism", cfg.MEKANISM_SAWMILL, MekanismSawmillProcessor::new));
            PROCESSORS.add(new ProcessorInfo("modern_industrialization", cfg.MODERN_INDUSTRIALIZATION_CUTTING_MACHINE, ModernIndustrializationCuttingMachineProcessor::new));
            PROCESSORS.add(new ProcessorInfo("farmersdelight", cfg.FARMERS_DELIGHT_CUTTING_BOARD, FarmersDelightCuttingBoardProcessor::new));
            PROCESSORS.add(new ProcessorInfo("immersiveengineering", cfg.IMMERSIVE_ENGINEERING_SAWMILL, ImmersiveEngineeringSawmillProcessor::new));
            if (mods.isLoaded("not_enough_glyphs")) {
                PROCESSORS.add(new ProcessorInfo("modern_industrialization", cfg.MODERN_INDUSTRIALIZATION_COMPRESSOR, ModernIndustrializationCompressorProcessor::new));
                PROCESSORS.add(new ProcessorInfo("ae2", cfg.PRESS_AE2_INSCRIBER_CIRCUIT_PRINTING, AE2CircuitPrintingProcesser::new));
            }
        }
        PROCESSORS.sort(Comparator.comparingInt(p -> (Integer)p.priority.get()).reversed());
        Stopwatch totalSw = Stopwatch.createStarted();
        for (ProcessorInfo processor : PROCESSORS) {
            if ((Integer)processor.priority.get() == -1 || !mods.isLoaded(processor.modid)) continue;
            Processor<?, ?> p2 = processor.constructor.apply(server);
            Stopwatch sw = Stopwatch.createStarted();
            p2.processRecipes();
            sw.stop();
            LOGGER.info("{} processed recipes in {}", (Object)p2.getClass().getSimpleName(), (Object)sw);
        }
        totalSw.stop();
        LOGGER.info("Finished processing recipes in {}", (Object)totalSw);
    }

    public static ResourceLocation prefix(String str) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)str);
    }

    public static Set<Item> crushRecipesIngredientSet(RecipeManager recipeManager) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeRegistry.CRUSH_TYPE.get());
        ObjectOpenHashSet set = new ObjectOpenHashSet(recipes.size());
        for (RecipeHolder recipe : recipes) {
            for (ItemStack stack : ((CrushRecipe)recipe.value()).input().getItems()) {
                set.add(stack.getItem());
            }
        }
        return set;
    }

    public static Set<Item> cutRecipesIngredientSet(RecipeManager recipeManager) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)AURecipeRegistry.CUT_TYPE.get());
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (RecipeHolder recipe : recipes) {
            for (ItemStack stack : ((CutRecipe)recipe.value()).input().getItems()) {
                set.add(stack.getItem());
            }
        }
        return set;
    }

    public static Set<Item> pressRecipesIngredientSet(RecipeManager recipeManager) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)AURecipeRegistry.PRESS_TYPE.get());
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (RecipeHolder recipe : recipes) {
            for (ItemStack stack : ((PressRecipe)recipe.value()).input().getItems()) {
                set.add(stack.getItem());
            }
        }
        return set;
    }

    public static ItemStack withAugmentTooltip(AbstractSpellPart item, AbstractAugment augment) {
        ItemStack stack = item.getGlyph().getDefaultInstance();
        MutableComponent component = Component.translatable((String)"ars_unification.augment_with", (Object[])new Object[]{Component.translatable((String)augment.getLocalizationKey())}).withStyle(ChatFormatting.RESET).withStyle(ChatFormatting.GOLD);
        stack.set(DataComponents.LORE, (Object)new ItemLore((List)ObjectLists.singleton((Object)component), (List)ObjectLists.singleton((Object)component)));
        return stack;
    }

    record ProcessorInfo(String modid, ModConfigSpec.IntValue priority, Function<MinecraftServer, Processor<?, ?>> constructor) {
    }
}

