/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.block.entity;

import appeng.api.AECapabilities;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.blockentity.powersink.IExternalPowerSink;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.definition.ArsEngBlockEntities;
import gripe._90.arseng.me.misc.SourceEnergyAdaptor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class SourceConverterBlockEntity
extends AENetworkedBlockEntity
implements IExternalPowerSink {
    private final SourceEnergyAdaptor adaptor = new SourceEnergyAdaptor(this, (IActionHost)this);

    public SourceConverterBlockEntity(BlockPos pos, BlockState state) {
        super(ArsEngBlockEntities.SOURCE_CONVERTER.get(), pos, state);
        this.getMainNode().setIdlePowerUsage(0.0);
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, ArsEngBlockEntities.SOURCE_CONVERTER.get(), (be, ctx) -> be);
        event.registerBlockEntity(CapabilityRegistry.SOURCE_CAPABILITY, ArsEngBlockEntities.SOURCE_CONVERTER.get(), (be, ctx) -> be.adaptor);
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().getEnergyDemand(maxRequired) : 0.0;
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().injectPower(power, mode) : 0.0;
    }

    public final double getExternalPowerDemand(PowerUnit externalUnit, double maxPowerRequired) {
        double demand = this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnit.AE, maxPowerRequired));
        return PowerUnit.AE.convertTo(externalUnit, Math.max(0.0, demand));
    }

    public final double injectExternalPower(PowerUnit input, double amt, Actionable mode) {
        return PowerUnit.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnit.AE, amt), mode));
    }

    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public double injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return 0.0;
    }

    public double getAEMaxPower() {
        return 0.0;
    }

    public double getAECurrentPower() {
        return 0.0;
    }

    public boolean isAEPublicPowerStorage() {
        return false;
    }
}

