/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.storage;

import com.buuz135.transfer_labels.TransferLabels;
import com.buuz135.transfer_labels.client.LabelShapes;
import com.buuz135.transfer_labels.packet.SingleLabelSyncPacket;
import com.buuz135.transfer_labels.storage.LabelInstance;
import com.buuz135.transfer_labels.storage.LabelStorage;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.network.Message;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class LabelBlock
implements INBTSerializable<CompoundTag> {
    private final BlockPos pos;
    private final Level level;
    private HashMap<Direction, LabelInstance> labels;

    public LabelBlock(BlockPos pos, Level level) {
        this.pos = pos;
        this.level = level;
        this.labels = new HashMap();
    }

    public void setLabel(Direction direction, ItemStack label) {
        this.labels.put(direction, new LabelInstance(label, this.level, this.pos, direction, this));
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public HashMap<Direction, LabelInstance> getLabels() {
        return this.labels;
    }

    public AABB collectShapes(Direction direction2) {
        if (direction2 == Direction.NORTH && this.labels.containsKey(Direction.NORTH)) {
            return LabelShapes.NORTH.move(this.getPos());
        }
        if (direction2 == Direction.SOUTH && this.labels.containsKey(Direction.SOUTH)) {
            return LabelShapes.SOUTH.move(this.getPos());
        }
        if (direction2 == Direction.EAST && this.labels.containsKey(Direction.EAST)) {
            return LabelShapes.EAST.move(this.getPos());
        }
        if (direction2 == Direction.WEST && this.labels.containsKey(Direction.WEST)) {
            return LabelShapes.WEST.move(this.getPos());
        }
        if (direction2 == Direction.UP && this.labels.containsKey(Direction.UP)) {
            return LabelShapes.UP.move(this.getPos());
        }
        if (direction2 == Direction.DOWN && this.labels.containsKey(Direction.DOWN)) {
            return LabelShapes.DOWN.move(this.getPos());
        }
        return null;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.labels.forEach((direction, labelInstance) -> {
            CompoundTag labelInstanceCompoundTag = new CompoundTag();
            labelInstanceCompoundTag.put("Stack", labelInstance.getLabel().saveOptional(provider));
            labelInstanceCompoundTag.put("Extra", (Tag)labelInstance.serializeNBT(provider));
            compoundTag.put(direction.name(), (Tag)labelInstanceCompoundTag);
        });
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        ArrayList visitedDirections = new ArrayList();
        compoundTag.getAllKeys().forEach(s -> {
            CompoundTag labelInstanceCompoundTag = compoundTag.getCompound(s);
            Direction direction = Direction.valueOf((String)s);
            visitedDirections.add(direction);
            LabelInstance instance = this.labels.computeIfAbsent(direction, direction1 -> new LabelInstance(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)labelInstanceCompoundTag.getCompound("Stack")), this.level, this.pos, direction, this));
            instance.deserializeNBT(provider, labelInstanceCompoundTag.getCompound("Extra"));
            this.labels.put(direction, instance);
        });
        this.labels.keySet().removeIf(direction -> !visitedDirections.contains(direction));
    }

    public void updateToNearby(Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TransferLabels.NETWORK.sendToNearby(this.level, this.pos, 32, (Message)new SingleLabelSyncPacket(this.pos, this.serializeNBT((HolderLookup.Provider)this.level.registryAccess())));
            LabelStorage.getStorageFor(serverLevel).markDirty();
        }
    }

    public void remove(Player player, Direction direction) {
        LabelInstance instance = this.getLabels().remove(direction);
        if (instance != null && player != null) {
            ItemStack original = instance.getLabel().copy();
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)original);
            InventoryComponent<LabelInstance> amount = instance.getAmountFilter();
            InventoryComponent<LabelInstance> speed = instance.getSpeedFilter();
            if (amount.getStackInSlot(0).getCount() > 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)amount.getStackInSlot(0).copy());
            }
            if (speed.getStackInSlot(0).getCount() > 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)speed.getStackInSlot(0).copy());
            }
        }
    }
}

