/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.filter.extras;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class NumberFilterExtra
implements INBTSerializable<CompoundTag> {
    private final int amount;
    private List<Integer> extra;

    public NumberFilterExtra(int amount) {
        this.amount = amount;
        this.extra = new ArrayList<Integer>();
        for (int i = 0; i < amount; ++i) {
            this.extra.add(1);
        }
    }

    public void add(int slot, int amount) {
        this.extra.set(slot, Math.max(0, Math.min(this.extra.get(slot) + amount, 0x7FFFFFFE)));
    }

    public List<Integer> getExtra() {
        return this.extra;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.extra.size(); ++i) {
            compoundTag.putInt("" + i, this.extra.get(i).intValue());
        }
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        compoundTag.getAllKeys().forEach(s -> this.extra.set(Integer.parseInt(s), compoundTag.getInt(s)));
    }
}

