/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.mixin;

import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class FixMobSpawningMixin {
    @Unique
    private static final ResourceKey<Structure> BETTER_FORTRESS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)BetterFortressesCommon.id("fortress"));

    @Inject(method={"isInNetherFortressBounds"}, at={@At(value="HEAD")}, cancellable=true)
    private static void betterfortresses_fixMobSpawning(BlockPos pos, ServerLevel level, MobCategory category, StructureManager structureManager, CallbackInfoReturnable<Boolean> cir) {
        Structure betterFortress;
        if (category == MobCategory.MONSTER && level.getBlockState(pos.below()).is(Blocks.NETHER_BRICKS) && (betterFortress = (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(BETTER_FORTRESS)) != null && structureManager.getStructureAt(pos, betterFortress).isValid()) {
            cir.setReturnValue((Object)true);
        }
    }
}

