/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.data.providers;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import com.supermartijn642.fusion.api.util.Pair;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.core.CSRegistry;
import java.nio.file.Path;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CSFusionModelProvider
extends FusionModelProvider {
    public CSFusionModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super("crystalix", new PackOutput(Path.of(packOutput.getOutputFolder().toAbsolutePath().toString(), "crystalix-fusion-overrides")), existingFileHelper);
    }

    protected void generate() {
        CSRegistry.ENTRIES.cellSet().forEach(cell -> {
            this.shadedBlock((DeferredHolder<Block, ? extends Block>)((DeferredHolder)cell.getValue()), (CSRegistry.Colors)cell.getColumnKey(), (CSRegistry.Types)((Object)((Object)cell.getRowKey())));
            this.shadelessBlock((DeferredHolder<Block, ? extends Block>)((DeferredHolder)cell.getValue()), (CSRegistry.Colors)cell.getColumnKey(), (CSRegistry.Types)((Object)((Object)cell.getRowKey())));
        });
    }

    private void shadedBlock(DeferredHolder<Block, ? extends Block> block, CSRegistry.Colors color, CSRegistry.Types type) {
        this.addModel(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + block.getId().getPath())), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"block/block"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + (color.color() < 0 ? color.key() : "color"))))).connection(DefaultConnectionPredicates.isSameBlock().and(new ConnectionPredicate[]{DefaultConnectionPredicates.matchState((Block)((Block)block.get()), (Pair[])new Pair[]{Pair.of((Object)CrystalixGlass.INVISIBLE, (Object)false)})})).build())));
    }

    private void shadelessBlock(DeferredHolder<Block, ? extends Block> block, CSRegistry.Colors color, CSRegistry.Types type) {
        this.addModel(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + block.getId().getPath() + "_no_shade")), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"block/no_shade_block"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + (color.color() < 0 ? color.key() : "color"))))).connection(DefaultConnectionPredicates.isSameBlock().and(new ConnectionPredicate[]{DefaultConnectionPredicates.matchState((Block)((Block)block.get()), (Pair[])new Pair[]{Pair.of((Object)CrystalixGlass.INVISIBLE, (Object)false)})})).build())));
    }
}

