/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.client.input;

import dev.satherov.utilityvest.common.item.UVVestItem;
import dev.satherov.utilityvest.common.menu.UVVestMenu;
import dev.satherov.utilityvest.core.lang.UVLanguage;
import dev.satherov.utilityvest.network.OpenVestPayload;
import dev.satherov.utilityvest.network.RestockPayload;
import dev.satherov.utilityvest.network.SaveLoadPayload;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class UVKeybindManager {
    public static final KeyMapping GUI_KEY = UVKeybindManager.register(UVLanguage.KEY_GUI, 82);
    public static final KeyMapping RESTOCK = UVKeybindManager.register(UVLanguage.KEY_RESTOCK, 88);
    public static final KeyMapping LOAD = UVKeybindManager.register(UVLanguage.KEY_LOAD, 341);
    public static final KeyMapping SAVE = UVKeybindManager.register(UVLanguage.KEY_SAVE, 342);

    private static KeyMapping register(UVLanguage key, int keyCode) {
        return new KeyMapping(key.getTranslationKey(), keyCode, UVLanguage.KEY_CATEGORY.getTranslationKey());
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (RESTOCK.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RestockPayload(player.isCrouching()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (GUI_KEY.consumeClick()) {
            Item item;
            if (player.containerMenu instanceof UVVestMenu) {
                player.closeContainer();
                return;
            }
            ItemStack stack = UVVestItem.getVest((Player)player, true);
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof UVVestItem) {
                UVVestItem vest = (UVVestItem)item;
                PacketDistributor.sendToServer((CustomPacketPayload)new OpenVestPayload(player.isCrouching(), vest.getMaxBanks()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (SAVE.isDown()) {
            for (int i = 0; i < 5; ++i) {
                if (event.getKey() != 49 + i || event.getAction() != 1) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new SaveLoadPayload(true, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        }
        if (LOAD.isDown()) {
            for (int i = 0; i < 5; ++i) {
                if (event.getKey() != 49 + i || event.getAction() != 1) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new SaveLoadPayload(false, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        }
    }
}

