/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;

public class ManaCircuitRenderer
implements BlockEntityRenderer<ManaCircuitTileEntity> {
    private static int[][] colors = new int[][]{{255, 0, 0}, {255, 106, 0}, {255, 204, 0}, {207, 255, 15}, {91, 255, 15}, {19, 227, 0}, {0, 240, 176}, {5, 219, 247}, {65, 32, 250}, {255, 71, 231}};

    public ManaCircuitRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(ManaCircuitTileEntity te, float v, PoseStack matrix, MultiBufferSource MultiBufferSource2, int var1, int var2) {
        int i;
        float[] scales;
        int i2;
        matrix.pushPose();
        matrix.translate(0.5f, 0.5f, 0.5f);
        long time = 0L;
        if (te.getLevel() != null) {
            time = ClientHandler.clientTickCounter;
        }
        int lx = 240;
        int ly = 240;
        int offset = 100;
        float a = 0.8f;
        int rings = 6;
        float[][] rgbs = new float[rings + 1][3];
        float[] heights = new float[]{0.02f, 0.02f, 0.04f, 0.04f, 0.05f, 0.05f};
        float[] pitches = new float[rings + 1];
        float[] yaws = new float[rings + 1];
        float[] rotations = new float[rings + 1];
        float colortime = time % 1000L;
        float ranges = 1000.0f / (float)colors.length;
        for (i2 = 0; i2 < rgbs.length; ++i2) {
            float cval = (colortime + (float)(offset * i2)) % 1000.0f;
            rgbs[i2] = ManaCircuitRenderer.valToColor(cval /= ranges, ranges);
            yaws[i2] = ManaCircuitRenderer.valToYaw(time + (long)(offset * i2));
            rotations[i2] = ManaCircuitRenderer.valToYaw(time + (long)((offset + 50) * i2));
            pitches[i2] = ManaCircuitRenderer.valToYaw(time + (long)((offset + 90) * i2));
        }
        if (!te.isRedstoneOn()) {
            scales = new float[]{0.2f, 0.11f, 0.11f, 0.11f, 0.11f, 0.11f, 0.11f};
            for (i2 = 0; i2 < rgbs.length; ++i2) {
                for (int j = 0; j < rgbs[i2].length; ++j) {
                    rgbs[i2][j] = 180.0f;
                }
            }
        } else {
            scales = new float[]{0.2f, 0.11f, 0.11f, 0.2f, 0.2f, 0.4f, 0.4f};
        }
        ManaCircuitRenderer.rotate(matrix, yaws[0], pitches[0], rotations[0]);
        ManaCircuitRenderer.drawCircle(matrix, scales[0], lx, ly, rgbs[0][0], rgbs[0][1], rgbs[0][2], a);
        ManaCircuitRenderer.unrotate(matrix, yaws[0], pitches[0], rotations[0]);
        int ring_index = 0;
        for (i = 1; i < rings + 1; ++i) {
            ManaCircuitRenderer.rotate(matrix, yaws[i], pitches[i], rotations[i]);
            RenderUtils.renderRing(matrix, MultiBufferSource2, (double)(heights[i - 1] * 0.5f), 90.0f, scales[i], heights[i - 1], 32, lx, ly, rgbs[i][0], rgbs[i][1], rgbs[i][2], a, ring_index);
            ManaCircuitRenderer.unrotate(matrix, yaws[i], pitches[i], rotations[i]);
            ++ring_index;
        }
        for (i = 0; i < 2; ++i) {
            int yaw = 45;
            if (i % 2 == 0) {
                yaw = -135;
            }
            ManaCircuitRenderer.rotate(matrix, yaw, 45.0f, ManaCircuitRenderer.valToYaw(time + (long)((offset + 90) * i)));
            RenderUtils.renderRing(matrix, MultiBufferSource2, (double)(heights[5] * 0.5f), 90.0f, scales[6], heights[5], 32, lx, ly, rgbs[i][0], rgbs[i][1], rgbs[i][2], a, ring_index);
            ManaCircuitRenderer.unrotate(matrix, yaw, 45.0f, ManaCircuitRenderer.valToYaw(time + (long)((offset + 90) * i)));
            ++ring_index;
        }
        matrix.popPose();
    }

    public static float[] valToColor(float val, float ranges) {
        int z = (int)Math.floor(val);
        int[] arr = colors[z %= colors.length];
        int y = z - 1 % colors.length;
        if (y < 0) {
            y += colors.length;
        }
        int[] arr2 = colors[y];
        float remainder = val * ranges % ranges / ranges;
        int rn = (int)((float)arr2[0] + remainder * (float)(arr[0] - arr2[0]));
        int gn = (int)((float)arr2[1] + remainder * (float)(arr[1] - arr2[1]));
        int bn = (int)((float)arr2[2] + remainder * (float)(arr[2] - arr2[2]));
        return new float[]{(float)rn / 255.0f, (float)gn / 255.0f, (float)bn / 255.0f};
    }

    public static float valToYaw(long val) {
        return (float)val * 2.0f % 360.0f;
    }

    public static void rotate(PoseStack matrix, float yaw, float pitch, float rotation) {
        matrix.mulPose(Axis.YP.rotationDegrees(yaw));
        matrix.mulPose(Axis.XP.rotationDegrees(pitch));
        matrix.mulPose(Axis.YP.rotationDegrees(rotation));
    }

    public static void unrotate(PoseStack matrix, float yaw, float pitch, float rotation) {
        matrix.mulPose(Axis.YP.rotationDegrees(-rotation));
        matrix.mulPose(Axis.XP.rotationDegrees(-pitch));
        matrix.mulPose(Axis.YP.rotationDegrees(-yaw));
    }

    public static void drawCircle(PoseStack matrix, float size, int lightmapX, int lightmapY, float r, float g, float b, float a) {
        matrix.pushPose();
        Matrix4f positionMatrix = matrix.last().pose();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer bb = buffer.getBuffer(type);
        bb.addVertex(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.endBatch(type);
        matrix.popPose();
    }

    public boolean shouldRenderOffScreen(ManaCircuitTileEntity te) {
        return true;
    }
}

