/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import stepsword.mahoutsukai.render.shader.ClipShaderInstance;
import stepsword.mahoutsukai.render.shader.FogShaderInstance;
import stepsword.mahoutsukai.render.shader.FullBrightShaderInstance;
import stepsword.mahoutsukai.render.shader.PassThroughShaderInstance;

public class ModShaders {
    public static FogShaderInstance FOGGY_QUADS;
    public static ClipShaderInstance CLIPPED_QUADS;
    public static FullBrightShaderInstance FULLBRIGHT_QUADS;
    public static PassThroughShaderInstance PASSTHROUGH_QUADS;

    public static void registerShaders(RegisterShadersEvent event) {
        ModShaders.registerFogPCTLShader("fog", s -> {
            FOGGY_QUADS = (FogShaderInstance)((Object)s);
        }, event);
        ModShaders.registerClipShader("clip", s -> {
            CLIPPED_QUADS = (ClipShaderInstance)((Object)s);
        }, event, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        ModShaders.registerFullbright("fullbright", s -> {
            FULLBRIGHT_QUADS = (FullBrightShaderInstance)((Object)s);
        }, event, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        ModShaders.registerPassThrough("passthrough", s -> {
            PASSTHROUGH_QUADS = (PassThroughShaderInstance)((Object)s);
        }, event, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
    }

    public static void registerFogPCTLShader(String name, Consumer<ShaderInstance> consumer, RegisterShadersEvent event) {
        try {
            event.registerShader((ShaderInstance)new FogShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)name), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), consumer);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void registerClipShader(String name, Consumer<ShaderInstance> consumer, RegisterShadersEvent event, VertexFormat format) {
        try {
            event.registerShader((ShaderInstance)new ClipShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)name), format), consumer);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void registerFullbright(String name, Consumer<ShaderInstance> consumer, RegisterShadersEvent event, VertexFormat format) {
        try {
            event.registerShader((ShaderInstance)new FullBrightShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)name), format), consumer);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void registerPassThrough(String name, Consumer<ShaderInstance> consumer, RegisterShadersEvent event, VertexFormat format) {
        try {
            event.registerShader((ShaderInstance)new PassThroughShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)name), format), consumer);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }
}

