/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.lwjgl.opengl.GL13C;
import org.lwjgl.opengl.GL30;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.tile.MahouRenderRL;

public class FogShaderInstance
extends ShaderInstance {
    public static ResourceLocation FOG_TEX = MahouRenderRL.fog;
    public static ResourceLocation DEPTH_TEX = MahouRenderRL.fog;
    public static boolean doDepth = true;
    Uniform SMOKE_SOFTNESS = new Uniform("uSmokeSoftness", 4, 1, (Shader)this);
    Uniform SMOKE_COLOR = new Uniform("uSmokeColor", 7, 4, (Shader)this);
    Uniform Z_NEAR_FAR = new Uniform("uNearFar", 5, 2, (Shader)this);
    Uniform W_H = new Uniform("uInvertedVp", 5, 2, (Shader)this);
    Uniform DEPTH_TEXTURE = new Uniform("uDepthTexture", 0, 1, (Shader)this);

    public FogShaderInstance(ResourceProvider provider, ResourceLocation shaderLocation, VertexFormat vertexFormat) throws IOException {
        super(provider, shaderLocation, vertexFormat);
        this.initializeUniform(this.SMOKE_SOFTNESS);
        this.initializeUniform(this.SMOKE_COLOR);
        this.initializeUniform(this.Z_NEAR_FAR);
        this.initializeUniform(this.W_H);
        this.initializeUniform(this.DEPTH_TEXTURE);
        this.smoke(0.06f);
        this.color(1.0f, 1.0f, 1.0f, 0.7f);
        this.nearfar(0.07f, 400.0f);
    }

    public void initializeUniform(Uniform uniform) {
        String s1 = uniform.getName();
        int k = Uniform.glGetUniformLocation((int)this.getId(), (CharSequence)s1);
        uniform.setLocation(k);
    }

    public void smoke(float f) {
        this.SMOKE_SOFTNESS.set(f);
    }

    public void nearfar(float n, float f) {
        this.Z_NEAR_FAR.set(n, f);
    }

    public void color(float r, float g, float b, float a) {
        this.SMOKE_COLOR.set(r, g, b, a);
    }

    public void resize(float w, float h) {
        this.W_H.set(1.0f / w, 1.0f / h);
    }

    public void initFog(int w, int h) {
        this.resize(w, h);
        this.printGLERROR("RESIZE");
        this.Z_NEAR_FAR.upload();
        this.printGLERROR("SET_NEAR_FAR");
        this.W_H.upload();
        this.printGLERROR("SET_INVERTED");
        this.SMOKE_COLOR.upload();
        this.printGLERROR("SET_COLOR");
        this.SMOKE_SOFTNESS.upload();
        this.printGLERROR("SET_SOFTNESS");
        this.depth(w, h);
        this.printGLERROR("DEPTH");
        this.finishFog();
        RenderSystem.enableBlend();
        RenderSystem.depthFunc((int)513);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public void finishFog() {
        GL13C.glActiveTexture((int)33984);
        this.printGLERROR("ACTIVE0");
        GlStateManager._activeTexture((int)33984);
        RenderUtils.bindTexture(FOG_TEX);
        this.printGLERROR("BIND");
    }

    public void depth(int w, int h) {
        GL30.glEnable((int)2929);
        GL13C.glActiveTexture((int)34001);
        RenderUtils.bindTexture(DEPTH_TEX);
        this.printGLERROR("BINDTEXTURE");
        GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL30.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL30.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        this.printGLERROR("PARAMETER");
        if (doDepth) {
            GL30.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)w, (int)h, (int)0);
        }
        this.printGLERROR("TEXIMAGE");
        this.DEPTH_TEXTURE.set(17);
        this.DEPTH_TEXTURE.upload();
        doDepth = false;
    }

    public void printGLERROR(String s) {
        int errorCheckValue = GL30.glGetError();
        if (errorCheckValue != 0) {
            System.err.println(s + ": Could not create shaders " + errorCheckValue);
        }
    }

    public void apply() {
        super.apply();
        Window mc = Minecraft.getInstance().getWindow();
        this.initFog(mc.getScreenWidth(), mc.getScreenHeight());
    }

    public void close() {
        this.SMOKE_SOFTNESS.close();
        this.SMOKE_COLOR.close();
        this.Z_NEAR_FAR.close();
        this.W_H.close();
        this.DEPTH_TEXTURE.close();
        super.close();
    }
}

