/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.render.tile.MahouRenderRL;

public class ParticleMagic
extends Particle {
    public String loc;
    public float[] rgba = new float[4];
    public float softness = 0.01f;
    public float rotation = 0.0f;
    public float sz = 0.2f;
    public double slow = 0.6;
    public boolean shaders = false;
    public int image;

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, boolean shaders) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, vx, vy, vz);
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.4f;
        float maxAge = 50.0f + sz * 100.0f;
        if (g == 1.0f) {
            maxAge = 25.0f + sz * 10.0f;
        }
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
        this.rgba[0] = r;
        this.rgba[1] = g;
        this.rgba[2] = b;
        this.rgba[3] = a;
        this.loc = loc;
        this.sz = sz;
        this.image = this.random.nextInt(6) + 1;
        this.shaders = shaders;
        this.slow = 0.6;
    }

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, boolean shaders, double slow) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, scale, vx, vy, vz, loc, sz, r, g, b, a, shaders);
        this.slow = slow;
    }

    public ParticleMagic(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, float maxAge) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, scale, vx, vy, vz, loc, sz, r, g, b, a, false);
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.xd *= this.slow;
        this.yd *= this.slow;
        this.zd *= this.slow;
        this.oRoll = this.roll;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderMagic(ParticleMagic particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        Entity e = Minecraft.getInstance().getCameraEntity();
        if (e != null) {
            RenderType fog;
            float a;
            float yaw = e.yRotO + (e.yRot - e.yRotO) * partialTicks;
            float pitch = e.xRotO + (e.xRot - e.xRotO) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(particle.rotation, 0.0f, 1.0f, 0.0f, matrix);
            matrix.scale(particle.sz, particle.sz, particle.sz);
            float r = particle.rgba[0];
            float g = particle.rgba[1];
            float b = particle.rgba[2];
            particle.rgba[3] = a = 1.0f - (float)particle.age / (float)particle.lifetime;
            int j = 240;
            int k = 240;
            float xx = 0.5f;
            float bxx = -xx;
            float yy = 0.0f;
            MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
            Matrix4f m = matrix.last().pose();
            ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)(particle.loc + particle.image + ".png"));
            if (!MTConfig.NO_SHADERS && !RenderUtils.turnOffMahouShaders() && particle.shaders) {
                ModShaders.FOGGY_QUADS.smoke(0.02f);
                ModShaders.FOGGY_QUADS.color(particle.rgba[0], particle.rgba[1], particle.rgba[2], particle.rgba[3]);
                ModShaders.FOGGY_QUADS.nearfar(0.07f, 400.0f);
                if (ModShaders.FOGGY_QUADS.MODEL_VIEW_MATRIX != null) {
                    ModShaders.FOGGY_QUADS.MODEL_VIEW_MATRIX.set(m);
                }
                if (ModShaders.FOGGY_QUADS.PROJECTION_MATRIX != null) {
                    ModShaders.FOGGY_QUADS.PROJECTION_MATRIX.set(RenderSystem.getProjectionMatrix());
                }
                fog = MahoujinRenderType.wrapGlowLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(MahouRenderRL.fog, 0, false, () -> ModShaders.FOGGY_QUADS)), particle.rgba, particle.softness, particle.shaders);
            } else {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.depthFunc((int)515);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShader(() -> ModShaders.PASSTHROUGH_QUADS);
                fog = MahoujinRenderType.wrapGlowLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(loc, 0, false)), particle.rgba, particle.softness, particle.shaders);
            }
            VertexConsumer bb = buf.getBuffer(fog);
            bb.addVertex(m, bxx, yy, bxx).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(j, k);
            bb.addVertex(m, bxx, yy, xx).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, xx, yy, xx).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, xx, yy, bxx).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(j, k);
            buf.endBatch(fog);
        }
        matrix.popPose();
    }
}

