/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.ColorRenderTypeBuffer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderClairvoyance {
    static ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/particle/white_magic_particle1.png");

    public static void renderPrediction(PoseStack matrix, Entity camera, float partialTicks) {
        Player player;
        if (camera instanceof Player && EffectUtil.hasBuff((LivingEntity)(player = (Player)camera), ModEffects.CLAIRVOYANCE)) {
            ClairvoyanceEyesPotion.iterator = ((ConcurrentHashMap.KeySetView)ClairvoyanceEyesPotion.predictionMap.keySet()).iterator();
            while (ClairvoyanceEyesPotion.iterator.hasNext()) {
                Vec3 b;
                PathfinderMob e = ClairvoyanceEyesPotion.iterator.next();
                Vec3 a = e.position();
                if (a.distanceTo(b = camera.position()) < (double)MTConfig.CLAIRVOYANCE_RANGE && e.isAlive()) {
                    Path path = ClairvoyanceEyesPotion.predictionMap.get(e);
                    CompoundTag nbt = new CompoundTag();
                    if (!ClairvoyanceEyesPotion.entityNBTMap.containsKey(e)) {
                        e.saveWithoutId(nbt);
                        nbt.putString("id", EntityType.getKey((EntityType)e.getType()).toString());
                        ClairvoyanceEyesPotion.entityNBTMap.put(e, nbt);
                    } else {
                        nbt = ClairvoyanceEyesPotion.entityNBTMap.get(e);
                    }
                    try {
                        Entity tmp = (Entity)EntityType.create((CompoundTag)nbt, (Level)e.level()).get();
                        PathfinderMob pred = null;
                        if (tmp instanceof PathfinderMob) {
                            pred = (PathfinderMob)tmp;
                        }
                        if (path == null || pred == null) continue;
                        pred.yRot = e.yRot;
                        if (path.isDone() || path.getNodeCount() <= path.getNextNodeIndex() + 1) continue;
                        int plength = path.getNodeCount();
                        for (int i = path.getNextNodeIndex(); i < plength; ++i) {
                            Node point = path.getNode(i);
                            pred.setPos((double)point.x, (double)point.y, (double)point.z);
                            if (a.distanceTo(pred.position()) < 1.0) {
                                path.setNextNodeIndex(i);
                            }
                            if (path.isDone() || path.getNodeCount() <= path.getNextNodeIndex() + 1) continue;
                            RenderClairvoyance.renderEntityStatic(pred, point.x, point.y, point.z, 0.0f, 0.0f, matrix, new ColorRenderTypeBuffer((MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 1.0f, 0.0f, 0.0f, 0.5f), 240);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                ClairvoyanceEyesPotion.iterator.remove();
                ClairvoyanceEyesPotion.entityNBTMap.remove(e);
            }
            ClairvoyanceEyesPotion.iterator = null;
        }
    }

    public static void renderPathPoint(Vec3 currv, Vec3 prevv, Vec3 nextv, float partialTicks, PoseStack matrixStackIn, MultiBufferSource.BufferSource buf, int packedLightIn, float sz1, float sz2) {
        Vec3 v = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float s1 = Math.min(sz1, 0.3f);
        float s2 = Math.min(sz2, 0.3f);
        Vec3 tmpv = currv;
        Vec3 diff = currv.subtract(prevv);
        float d = (float)diff.length();
        diff = diff.normalize();
        float[] rgba = new float[]{1.0f, 0.0f, 0.0f, 0.7f};
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        RenderType rt = MahoujinRenderType.wrapGlowLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(loc, 0, false)), rgba, 0.4f, false);
        float step = 0.05f;
        for (float i = 0.0f; i < d; i += step) {
            tmpv = prevv.add(diff.scale((double)i));
            double t = i / d;
            tmpv = RenderUtils.bezier(t, prevv, currv, nextv);
            float sz = s1 + (s2 - s1) * i / (d / step);
            double d2 = tmpv.x - v.x;
            double d3 = tmpv.y - v.y + 0.5;
            double d0 = tmpv.z - v.z;
            matrixStackIn.pushPose();
            matrixStackIn.translate(d2, d3, d0);
            RenderUtils.billboard(matrixStackIn, 0.0f, partialTicks);
            matrixStackIn.scale(sz, sz, sz);
            Matrix4f m = matrixStackIn.last().pose();
            VertexConsumer bb = buf.getBuffer(rt);
            float xx = 0.5f;
            float bxx = -xx;
            float yy = 0.0f;
            bb.addVertex(m, bxx, yy, bxx).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(240, 240);
            bb.addVertex(m, bxx, yy, xx).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(240, 240);
            bb.addVertex(m, xx, yy, xx).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(240, 240);
            bb.addVertex(m, xx, yy, bxx).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(240, 240);
            buf.endBatch(rt);
            matrixStackIn.popPose();
        }
    }

    public static <E extends Entity> void renderEntityStatic(E entityIn, double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            Vec3 v = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entityIn);
            Vec3 Vec32 = entityRenderer.getRenderOffset(entityIn, partialTicks);
            double d2 = xIn + Vec32.x() - v.x;
            double d3 = yIn + Vec32.y() - v.y;
            double d0 = zIn + Vec32.z() - v.z;
            matrixStackIn.pushPose();
            matrixStackIn.translate(d2, d3, d0);
            entityRenderer.render(entityIn, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.translate(-d2, -d3, -d0);
            matrixStackIn.popPose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

