/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class MahoujinHUD {
    public static void renderHUD(GuiGraphics graphics, Minecraft mc) {
        UnorderedList ul;
        int xc = mc.getWindow().getGuiScaledWidth() / 2;
        int yc = mc.getWindow().getGuiScaledHeight() / 2;
        int radius = 24;
        LocalPlayer player = mc.player;
        IMahou mahou = Utils.getPlayerMahou((Player)player);
        if (mahou != null && (ul = mahou.getLastRecipe()) != null) {
            ArrayList<String> catalysts = ul.getOrder();
            if (ul.size() == 3 && catalysts.size() == 3) {
                boolean clothRequired = mahou.getLastRecipeCloth();
                boolean hasClothInInventory = false;
                boolean hasAllCatalysts = true;
                Set<String> hs = ul.getKeys();
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    IItemHandler inv;
                    ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                    if (stack.getItem() instanceof PowderedCatalyst) {
                        PowderedCatalyst c = (PowderedCatalyst)stack.getItem();
                        for (String s : hs) {
                            if (!c.getCatalystName().equals(s)) continue;
                            if (counts.containsKey(s)) {
                                counts.put(s, (Integer)counts.get(s) + stack.getCount());
                                continue;
                            }
                            counts.put(s, stack.getCount());
                        }
                    } else if (Utils.getInventory(stack) != null && (inv = Utils.getInventory(stack)) != null) {
                        for (int j = 0; j < inv.getSlots(); ++j) {
                            ItemStack st2 = inv.getStackInSlot(j);
                            if (st2.getItem() instanceof PowderedCatalyst) {
                                PowderedCatalyst c = (PowderedCatalyst)st2.getItem();
                                for (String s : hs) {
                                    if (!c.getCatalystName().equals(s)) continue;
                                    if (counts.containsKey(s)) {
                                        counts.put(s, (Integer)counts.get(s) + st2.getCount());
                                        continue;
                                    }
                                    counts.put(s, st2.getCount());
                                }
                            }
                            if (st2.getItem() != Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                            hasClothInInventory = true;
                        }
                    }
                    if (stack.getItem() != Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                    hasClothInInventory = true;
                }
                for (String s : hs) {
                    if (counts.containsKey(s)) {
                        if (ul.get(s) <= (Integer)counts.get(s)) continue;
                        hasAllCatalysts = false;
                        continue;
                    }
                    hasAllCatalysts = false;
                }
                if (hasAllCatalysts && (hasClothInInventory || !clothRequired)) {
                    for (String s : catalysts) {
                        ItemStack stack = new ItemStack((ItemLike)MahoujinRecipeRegistrar.ingredients.get(s));
                        Lighting.setupForFlatItems();
                        graphics.renderItem(stack, xc + radius + 32, yc - 8);
                        Lighting.setupFor3DItems();
                        yc -= 11;
                    }
                    if (clothRequired) {
                        ItemStack stack = new ItemStack((ItemLike)Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get())));
                        Lighting.setupForFlatItems();
                        graphics.renderItem(stack, xc + radius + 32, yc - 8);
                        Lighting.setupFor3DItems();
                        yc -= 8;
                    }
                }
                mc.font.drawInBatch("+", (float)(xc + radius + 14), (float)(yc + 10), 0xFFFFFF, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
    }
}

