/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderGateWeaponProjectile
extends EntityRenderer<GateWeaponProjectileEntity> {
    public RenderGateWeaponProjectile(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(GateWeaponProjectileEntity weapon, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.pushPose();
        float s = 2.5f;
        float ryaw = 90.0f + weapon.yRotO + (weapon.yRot - weapon.yRotO) * partialTicks;
        float rpitch = 135.0f - weapon.xRotO + (weapon.xRot - weapon.xRotO) * partialTicks;
        float progress = weapon.getProgress();
        float progresscap = weapon.getProgressCap();
        boolean flag = progress < progresscap;
        float yRotate = -90.0f + weapon.yRotO + (weapon.yRot - weapon.yRotO) * partialTicks;
        float pRotate = 90.0f + weapon.xRotO + (weapon.xRot - weapon.xRotO) * partialTicks;
        float ytranslate = progress + (progress - weapon.lastProgress) * partialTicks - 2.0f;
        matrix.pushPose();
        RenderUtils.rotateQ(yRotate, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pRotate, 0.0f, 0.0f, 1.0f, matrix);
        matrix.translate(0.0f, ytranslate, 0.0f);
        matrix.scale(s, s, s);
        if (flag) {
            this.drawCircle(0.0f, matrix, weapon.getTColor());
        }
        matrix.scale(1.0f / s, 1.0f / s, 1.0f / s);
        matrix.translate(0.0f, -ytranslate, 0.0f);
        RenderUtils.rotateQ(-pRotate, 0.0f, 0.0f, 1.0f, matrix);
        RenderUtils.rotateQ(-yRotate, 0.0f, 1.0f, 0.0f, matrix);
        matrix.popPose();
        matrix.mulPose(RenderUtils.getQuaternion(new Vector3f(0.0f, 1.0f, 0.0f), ryaw, true));
        matrix.mulPose(RenderUtils.getQuaternion(new Vector3f(0.0f, 0.0f, 1.0f), rpitch, true));
        matrix.translate(-0.59, -0.59, -0.59);
        matrix.scale(s, s, s);
        ItemStack stack = weapon.getStack();
        BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, weapon.getId());
        Vec3 zz = weapon.position();
        RenderUtils.renderClippedItem(stack, ItemDisplayContext.GROUND, false, matrix, buffer, packedLight, OverlayTexture.NO_OVERLAY, bakedModel, ytranslate, zz.x, zz.y, zz.z, weapon.yRot, weapon.xRot, s, flag);
        matrix.popPose();
        super.render((Entity)weapon, yaw, partialTicks, matrix, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(GateWeaponProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    private void drawCircle(float progress, PoseStack matrix, float[] colors) {
        int lightmapX = 240;
        int lightmapY = 240;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = 1.0f;
        Matrix4f positionMatrix = matrix.last().pose();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, true);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer bb = buffer.getBuffer(type);
        bb.addVertex(positionMatrix, -0.5f, progress, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, -0.5f, progress, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 0.5f, progress, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 0.5f, progress, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.endBatch(type);
    }
}

