/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.CooldownPotion;
import stepsword.mahoutsukai.potion.ExtraPotionInterface;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperInvisCooldownPotion
extends CooldownPotion
implements ExtraPotionInterface {
    protected RipperInvisCooldownPotion() {
    }

    @Override
    public void onRemove(LivingEntity livingEntity, MobEffect effect) {
        if (effect instanceof RipperInvisPotion && livingEntity.getOffhandItem().getItem() == livingEntity.getMainHandItem().getItem() && livingEntity.getMainHandItem().getItem() == ModItems.theripper.get()) {
            int manafog = MTConfig.RIPPER_INVIS_MANA_COST;
            if (livingEntity instanceof Player && PlayerManaManager.drainMana((Player)livingEntity, manafog, false, false) == manafog) {
                EffectUtil.buff(livingEntity, ModEffects.RIPPER_INVISIBILITY, false, 2000000000, false);
                RipperInvisPotion.notifyIfInvisible(livingEntity);
            }
        }
    }

    @Override
    public void onAdd(LivingEntity livingEntity, MobEffect effect) {
    }

    public static void nudge(LivingEntity livingEntity) {
        if (!livingEntity.level().isClientSide) {
            float radius = MTConfig.RIPPER_FOG_RANGE;
            Vec3 pos = livingEntity.position();
            AABB aabb = new AABB(pos.x - (double)radius, pos.y - (double)radius, pos.z - (double)radius, pos.x + (double)radius, pos.y + (double)radius, pos.z + (double)radius);
            List lst = livingEntity.level().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity e : lst) {
                if (e.getLastHurtByMob() == livingEntity) {
                    e.setLastHurtByMob(null);
                }
                if (e.lastHurtByPlayer == livingEntity) {
                    e.setLastHurtByPlayer(null);
                }
                if (!(e instanceof Mob) || ((Mob)e).getTarget() != livingEntity) continue;
                ((Mob)e).setTarget(null);
                ((Mob)e).goalSelector.getAvailableGoals().forEach(goal -> {
                    if (goal.getGoal() instanceof NearestAttackableTargetGoal) {
                        goal.stop();
                        ((Mob)e).goalSelector.removeGoal((Goal)goal);
                    }
                    if (goal.getGoal() instanceof TargetGoal) {
                        goal.stop();
                        ((Mob)e).goalSelector.removeGoal((Goal)goal);
                    }
                    if (goal.getGoal() instanceof SwellGoal) {
                        goal.stop();
                        ((Mob)e).goalSelector.removeGoal((Goal)goal);
                    }
                    if (goal.getGoal() instanceof LookAtPlayerGoal) {
                        goal.stop();
                        ((Mob)e).goalSelector.removeGoal((Goal)goal);
                    }
                    if (goal.getGoal().getClass().toString().toLowerCase().contains("attack")) {
                        goal.stop();
                        ((Mob)e).goalSelector.removeGoal((Goal)goal);
                    }
                });
            }
        }
    }
}

