/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ScrollPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FearPotion
extends ScrollPotion {
    protected FearPotion() {
        super(ModEffects.getColorNumber(255, 255, 240));
    }

    public static void fearLivingUpdate(LivingEntity entity) {
        Player player;
        ILivingMahou mahou;
        if (entity instanceof PathfinderMob && !entity.level().isClientSide && (mahou = Utils.getLivingMahou(entity)) != null && EffectUtil.hasBuff(entity, ModEffects.FEAR) && mahou.getFearPerson() != null && (player = entity.level().getPlayerByUUID(mahou.getFearPerson())) != null) {
            Vec3 runThisWay = entity.position().subtract(player.position());
            PathfinderMob creature = (PathfinderMob)entity;
            Vec3 go = creature.position().add(runThisWay.normalize().scale(3.0)).add((double)entity.getRandom().nextFloat() * 0.2, (double)entity.getRandom().nextFloat() * 0.2, (double)entity.getRandom().nextFloat() * 0.2);
            creature.setTarget(null);
            creature.setLastHurtByMob(null);
            creature.getMoveControl().setWantedPosition(go.x, go.y, go.z, 1.75);
        }
    }

    public static boolean fearLivingSetAttack(LivingEntity entity, LivingEntity target) {
        if (!entity.level().isClientSide && entity instanceof Mob && EffectUtil.hasBuff(entity, ModEffects.FEAR) && target != null) {
            ((Mob)entity).setTarget(null);
            entity.setLastHurtByMob(null);
        }
        return EffectUtil.hasBuff(entity, ModEffects.FEAR);
    }

    public static void fearPlayerTick(Player player) {
        if (player.getMainHandItem().getItem() == ModItems.caliburn.get()) {
            int radius = MTConfig.POWER_CONSOLIDATION_FEAR_RADIUS;
            AABB aabb = new AABB(Utils.toBlockPos(player.position().add((double)(-radius), -4.0, (double)(-radius))).getCenter(), Utils.toBlockPos(player.position().add((double)radius, 4.0, (double)radius)).getCenter());
            List lst = player.level().getEntitiesOfClass(PathfinderMob.class, aabb);
            for (PathfinderMob entity : lst) {
                ILivingMahou mahou;
                if (!Caliburn.specialTarget((LivingEntity)entity) || (mahou = Utils.getLivingMahou((LivingEntity)entity)) == null) continue;
                mahou.setFearPerson(player.getUUID());
                EffectUtil.buff((LivingEntity)entity, ModEffects.FEAR, false, 100);
            }
        }
    }
}

